/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.reporting.AbstractMessageQueue;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class AbstractMessageQueueTest
extends TestCase {
    private static final MessageTypeInt TEST_ERROR = new TestMessageType(MessageLevel.ERROR, "test error");
    private static final MessageTypeInt TEST_WARNING = new TestMessageType(MessageLevel.WARNING, "test warning");
    private MessageContext mc;
    private MessageQueue mq;

    public void setUp() {
        this.mc = new MessageContext();
        this.mq = new AbstractMessageQueue(){
            private List<Message> messages = new ArrayList<Message>();

            @Override
            public List<Message> getMessages() {
                return this.messages;
            }
        };
    }

    public void tearDown() {
        this.mc = null;
        this.mq = null;
    }

    public final void testAddMessageSimple() {
        AbstractMessageQueueTest.assertEquals((int)0, (int)this.mq.getMessages().size());
        this.mq.addMessage(TEST_WARNING, MessagePart.Factory.valueOf("test"));
        AbstractMessageQueueTest.assertEquals((int)1, (int)this.mq.getMessages().size());
        AbstractMessageQueueTest.assertEquals((Object)((Object)MessageLevel.WARNING), (Object)((Object)this.mq.getMessages().get(0).getMessageLevel()));
        AbstractMessageQueueTest.assertEquals((String)"test warning test", (String)this.mq.getMessages().get(0).format(this.mc));
    }

    public final void testAddMessageWithLevel() {
        AbstractMessageQueueTest.assertEquals((int)0, (int)this.mq.getMessages().size());
        this.mq.addMessage(TEST_WARNING, MessageLevel.ERROR, MessagePart.Factory.valueOf("test"));
        AbstractMessageQueueTest.assertEquals((int)1, (int)this.mq.getMessages().size());
        AbstractMessageQueueTest.assertEquals((Object)((Object)MessageLevel.ERROR), (Object)((Object)this.mq.getMessages().get(0).getMessageLevel()));
        AbstractMessageQueueTest.assertEquals((String)"test warning test", (String)this.mq.getMessages().get(0).format(this.mc));
    }

    public final void testHasMessageAtLevel() {
        AbstractMessageQueueTest.assertEquals((int)0, (int)this.mq.getMessages().size());
        this.mq.addMessage(TEST_WARNING, MessagePart.Factory.valueOf("test"));
        AbstractMessageQueueTest.assertEquals((int)1, (int)this.mq.getMessages().size());
        AbstractMessageQueueTest.assertFalse((boolean)this.mq.hasMessageAtLevel(MessageLevel.ERROR));
        this.mq.addMessage(TEST_ERROR, MessagePart.Factory.valueOf("test"));
        AbstractMessageQueueTest.assertEquals((int)2, (int)this.mq.getMessages().size());
        AbstractMessageQueueTest.assertTrue((boolean)this.mq.hasMessageAtLevel(MessageLevel.ERROR));
    }

    private static class TestMessageType
    implements MessageTypeInt {
        private final MessageLevel level;
        private final String name;

        public TestMessageType(MessageLevel level, String name) {
            this.level = level;
            this.name = name;
        }

        public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
            out.append(this.name);
            out.append(" ");
            parts[0].format(context, out);
        }

        public MessageLevel getLevel() {
            return this.level;
        }

        public int getParamCount() {
            return 1;
        }

        public String name() {
            return this.name;
        }
    }
}

