/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.SnippetProducer;
import com.google.caja.util.Maps;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.Map;
import junit.framework.TestCase;

public class SnippetProducerTest
extends TestCase {
    static final String F1_TEXT = "f1 line 1\n\r\nf1 line 3\n";
    static final String F2_TEXT = "f2\tline 1";
    static final String F3_TEXT = "123456789.abcdefghi.123456789.ABCDEFGHI.";
    SnippetProducer s;
    SnippetProducer s10;
    final InputSource f1 = new InputSource(URI.create("file:///f1"));
    final InputSource f2 = new InputSource(URI.create("file:///f2"));
    final InputSource f3 = new InputSource(URI.create("file:///f3"));

    public void setUp() throws Exception {
        super.setUp();
        Map<InputSource, String> originalSource = Maps.newHashMap();
        originalSource.put(this.f1, F1_TEXT);
        originalSource.put(this.f2, F2_TEXT);
        originalSource.put(this.f3, F3_TEXT);
        MessageContext mc = new MessageContext();
        mc.addInputSource(this.f1);
        mc.addInputSource(this.f2);
        mc.addInputSource(this.f3);
        this.s = new SnippetProducer(originalSource, mc);
        this.s10 = new SnippetProducer(originalSource, mc, 10);
    }

    public final void testGetSnippetNoPos() {
        Message msg = new Message((MessageTypeInt)TestMessageType.ZERO, new MessagePart[0]);
        SnippetProducerTest.assertEquals((String)"", (String)this.s.getSnippet(msg));
    }

    public final void testGetSnippetOnePartNoPos() {
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, MessagePart.Factory.valueOf("hi"));
        SnippetProducerTest.assertEquals((String)"", (String)this.s.getSnippet(msg));
    }

    public final void testGetSnippetOnePos() {
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, FilePosition.instance(this.f2, 1, 4, 4, 4));
        SnippetProducerTest.assertEquals((String)"f2:1: f2      line 1\n              ^^^^", (String)this.s.getSnippet(msg));
    }

    public final void testGetSnippetTwoPos() {
        CharProducer cp = CharProducer.Factory.create(new StringReader(F1_TEXT), this.f1);
        cp.consume(cp.length());
        Message msg = new Message((MessageTypeInt)TestMessageType.TWO, FilePosition.instance(this.f2, 1, 1, 1, 2), cp.getSourceBreaks(0).toFilePosition(1 + F1_TEXT.indexOf("\r\nf1 line 3"), 1 + F1_TEXT.indexOf(" line 3")));
        SnippetProducerTest.assertEquals((String)"f2:1: f2      line 1\n      ^^\nf1:3: f1 line 3\n      ^^", (String)this.s.getSnippet(msg));
    }

    public final void testZeroLengthRegion() {
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, FilePosition.instance(this.f2, 1, 3, 3));
        SnippetProducerTest.assertEquals((String)"f2:1: f2      line 1\n        ^", (String)this.s.getSnippet(msg));
    }

    public final void testZeroLengthAtEndOfLine() {
        int nlPos = 1 + F1_TEXT.indexOf(10);
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, FilePosition.instance(this.f1, 1, nlPos, nlPos));
        SnippetProducerTest.assertEquals((String)"f1:1: f1 line 1\n               ^", (String)this.s.getSnippet(msg));
    }

    public final void testZeroLengthAtEndOfFile() {
        int endPos = 1 + F2_TEXT.length();
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, FilePosition.instance(this.f2, 1, endPos, endPos));
        SnippetProducerTest.assertEquals((String)"f2:1: f2      line 1\n                    ^", (String)this.s.getSnippet(msg));
    }

    public final void testLongLineUncut() {
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, FilePosition.instance(this.f3, 1, 5, 5, 5));
        SnippetProducerTest.assertEquals((String)"f3:1: 123456789.abcdefghi.123456789.ABCDEFGHI.\n          ^^^^^", (String)this.s.getSnippet(msg));
    }

    public final void testLongLineCutRight() {
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, FilePosition.instance(this.f3, 1, 5, 5, 5));
        SnippetProducerTest.assertEquals((String)"f3:1: 123456789.\n          ^^^^^", (String)this.s10.getSnippet(msg));
    }

    public final void testLongLineCutLeft() {
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, FilePosition.instance(this.f3, 1, 35, 35, 3));
        SnippetProducerTest.assertEquals((String)"f3:1: 89.ABCDEFG\n             ^^^", (String)this.s10.getSnippet(msg));
    }

    public final void testLongLineCutBoth() {
        Message msg = new Message((MessageTypeInt)TestMessageType.ONE, FilePosition.instance(this.f3, 1, 15, 15, 20));
        SnippetProducerTest.assertEquals((String)"f3:1: efghi.1234\n      ^^^^^^^^^^", (String)this.s10.getSnippet(msg));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestMessageType implements MessageTypeInt
    {
        ZERO("ZERO", MessageLevel.LOG),
        ONE("%s: ONE", MessageLevel.WARNING),
        TWO("%s: TWO %s", MessageLevel.ERROR),
        THREE("%s: THREE %s %s", MessageLevel.FATAL_ERROR);

        private final String formatString;
        private final MessageLevel level;
        private final int paramCount;

        private TestMessageType(String formatString, MessageLevel level) {
            this.formatString = formatString;
            this.level = level;
            this.paramCount = MessageType.formatStringArity(formatString);
        }

        @Override
        public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
            MessageType.formatMessage(this.formatString, parts, context, out);
        }

        @Override
        public MessageLevel getLevel() {
            return this.level;
        }

        @Override
        public int getParamCount() {
            return this.paramCount;
        }
    }
}

