/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.Strings;
import junit.framework.TestCase;

public class StringsTest
extends TestCase {
    public final void testEqualsIgnoreCase() {
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase(null, null));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("", ""));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("foo", "foo"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("foo", "FOO"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("FOO", "foo"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("123", "123"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("FOO-bar", "foo-BAR"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("FOO^bar", "foo^BAR"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("FOO bar", "foo BAR"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("FOO~bar", "foo~BAR"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("foo-BAR", "FOO-bar"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("foo^BAR", "FOO^bar"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("foo BAR", "FOO bar"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase("foo~BAR", "FOO~bar"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("foo-BAR", "FOO^bar"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("foo^BAR", "FOO-bar"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("foo BAR", "FOO~bar"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("foo~BAR", "FOO bar"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("@", "`"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("`", "@"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("[", "{"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("{", "["));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase(null, ""));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("", null));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("", "foo"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("food", "foo"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("foo", "FOOd"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("123", "456"));
        StringsTest.assertFalse((boolean)Strings.equalsIgnoreCase("\u0391", "\u03b1"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase(" !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~", " !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase(" !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", " !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase(" !\"#$%&\\'()*+,-./0123456789:;<=>?@abcdefghijklmnopqrstuvwxyz[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", " !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"));
        StringsTest.assertTrue((boolean)Strings.equalsIgnoreCase(" !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", " !\"#$%&\\'()*+,-./0123456789:;<=>?@abcdefghijklmnopqrstuvwxyz[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"));
    }

    public final void testIsLowerCase() {
        StringsTest.assertTrue((boolean)Strings.isLowerCase(""));
        StringsTest.assertTrue((boolean)Strings.isLowerCase("foo"));
        StringsTest.assertTrue((boolean)Strings.isLowerCase("123"));
        StringsTest.assertTrue((boolean)Strings.isLowerCase("foo-bar"));
        StringsTest.assertTrue((boolean)Strings.isLowerCase("\u0391"));
        StringsTest.assertTrue((boolean)Strings.isLowerCase("\u03b1"));
        StringsTest.assertTrue((boolean)Strings.isLowerCase("@`[{"));
        StringsTest.assertFalse((boolean)Strings.isLowerCase("FOO"));
        StringsTest.assertFalse((boolean)Strings.isLowerCase("Foo"));
        StringsTest.assertFalse((boolean)Strings.isLowerCase("fooD"));
        StringsTest.assertFalse((boolean)Strings.isLowerCase("fooD!"));
    }

    public final void testToLowerCase() {
        StringsTest.assertEquals((String)"", (String)Strings.toLowerCase(""));
        StringsTest.assertEquals((String)"foo", (String)Strings.toLowerCase("foo"));
        StringsTest.assertEquals((String)"foo", (String)Strings.toLowerCase("FOO"));
        StringsTest.assertEquals((String)"foo", (String)Strings.toLowerCase("Foo"));
        StringsTest.assertEquals((String)"123", (String)Strings.toLowerCase("123"));
        StringsTest.assertEquals((String)"foo-bar", (String)Strings.toLowerCase("foo-BAR"));
        StringsTest.assertEquals((String)"foo-bar", (String)Strings.toLowerCase("FOO-bar"));
        StringsTest.assertEquals((String)"food", (String)Strings.toLowerCase("food"));
        StringsTest.assertEquals((String)"food", (String)Strings.toLowerCase("FOOd"));
        StringsTest.assertEquals((String)"456", (String)Strings.toLowerCase("456"));
        StringsTest.assertEquals((String)"\u0391", (String)Strings.toLowerCase("\u0391"));
        StringsTest.assertEquals((String)"\u03b1", (String)Strings.toLowerCase("\u03b1"));
        StringsTest.assertEquals((String)"@`[{", (String)Strings.toLowerCase("@`[{"));
        StringsTest.assertEquals((String)" !\"#$%&\\'()*+,-./0123456789:;<=>?@abcdefghijklmnopqrstuvwxyz[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (String)Strings.toLowerCase(" !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"));
    }

    public final void testToUpperCase() {
        StringsTest.assertEquals((String)"", (String)Strings.toUpperCase(""));
        StringsTest.assertEquals((String)"FOO", (String)Strings.toUpperCase("foo"));
        StringsTest.assertEquals((String)"FOO", (String)Strings.toUpperCase("FOO"));
        StringsTest.assertEquals((String)"FOO", (String)Strings.toUpperCase("Foo"));
        StringsTest.assertEquals((String)"123", (String)Strings.toUpperCase("123"));
        StringsTest.assertEquals((String)"FOO-BAR", (String)Strings.toUpperCase("foo-BAR"));
        StringsTest.assertEquals((String)"FOO-BAR", (String)Strings.toUpperCase("FOO-bar"));
        StringsTest.assertEquals((String)"FOOD", (String)Strings.toUpperCase("food"));
        StringsTest.assertEquals((String)"FOOD", (String)Strings.toUpperCase("FOOd"));
        StringsTest.assertEquals((String)"456", (String)Strings.toUpperCase("456"));
        StringsTest.assertEquals((String)"\u0391", (String)Strings.toUpperCase("\u0391"));
        StringsTest.assertEquals((String)"\u03b1", (String)Strings.toUpperCase("\u03b1"));
        StringsTest.assertEquals((String)"@`[{", (String)Strings.toUpperCase("@`[{"));
        StringsTest.assertEquals((String)" !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~", (String)Strings.toUpperCase(" !\"#$%&\\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"));
    }
}

