/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.RhinoExecutor;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUtil {
    private TestUtil() {
    }

    public static boolean isJava15() {
        String version = System.getProperty("java.version");
        return version != null && version.startsWith("1.5.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(Class<?> requestingClass, String filename) throws IOException {
        InputStream ins = TestUtil.getResourceAsStream(requestingClass, filename);
        if (null == ins) {
            throw new FileNotFoundException("Failed to read " + filename + " relative to " + requestingClass);
        }
        try {
            int n;
            BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[1024];
            while ((n = in.read(buf)) > 0) {
                sb.append(buf, 0, n);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            ins.close();
        }
    }

    public static MessageQueue createTestMessageQueue(MessageContext mc) {
        boolean verbose = "true".equals(System.getProperty("junit.verbose"));
        return new EchoingMessageQueue(new PrintWriter(new OutputStreamWriter(System.err)), mc, verbose);
    }

    public static URI getResource(Class<?> cl, String resource) {
        URL url = cl.getResource(resource);
        try {
            return null != url ? url.toURI() : null;
        }
        catch (URISyntaxException ex) {
            throw new SomethingWidgyHappenedError("The following url is not a valid uri: " + url);
        }
    }

    public static InputStream getResourceAsStream(Class<?> cl, String resource) throws IOException {
        URI uri = TestUtil.getResource(cl, resource);
        if (null == uri) {
            throw new FileNotFoundException("Resource " + resource + " relative to " + cl);
        }
        URLConnection conn = uri.toURL().openConnection();
        conn.connect();
        return conn.getInputStream();
    }

    public static CharProducer getResourceAsProducer(Class<?> cl, String resource) throws IOException {
        URI uri = TestUtil.getResource(cl, resource);
        if (null == uri) {
            throw new FileNotFoundException("Resource " + resource + " relative to " + cl);
        }
        URLConnection conn = uri.toURL().openConnection();
        conn.connect();
        return CharProducer.Factory.create((Reader)new InputStreamReader(conn.getInputStream(), "UTF-8"), new InputSource(uri));
    }

    public static String format(ParseTreeNode n) {
        StringBuilder output = new StringBuilder();
        try {
            n.format(new MessageContext(), output);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilder does not throw IOException", (Throwable)ex);
        }
        return output.toString();
    }

    public static MessageLevel maxMessageLevel(MessageQueue mq) {
        MessageLevel max = MessageLevel.values()[0];
        for (Message msg : mq.getMessages()) {
            MessageLevel lvl = msg.getMessageLevel();
            if (max.compareTo(lvl) >= 0) continue;
            max = lvl;
        }
        return max;
    }

    public static boolean hasErrors(MessageQueue mq) {
        return MessageLevel.ERROR.compareTo(TestUtil.maxMessageLevel(mq)) <= 0;
    }

    public static boolean hasErrorsOrWarnings(MessageQueue mq) {
        return MessageLevel.WARNING.compareTo(TestUtil.maxMessageLevel(mq)) <= 0;
    }

    public static void enableContentUrls() {
        RhinoExecutor.enableContentUrls();
    }

    public static String makeContentUrl(String content) {
        return "content:" + UriUtil.encode(content).replace("+", "%20");
    }

    public static void removePseudoNodes(ParseTreeNode node) {
        assert (!(node instanceof TranslatedCode));
        node.acceptPostOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                if (ac.node instanceof TranslatedCode) {
                    ((MutableParseTreeNode)ac.parent.node).replaceChild(((TranslatedCode)ac.node).getTranslation(), (ParseTreeNode)ac.node);
                }
                return true;
            }
        }, null);
    }
}

