/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xcmis.search.lucene.index.TransactionLog;
import org.xcmis.search.lucene.index.TransactionLogException;

public class CompositeTransactionLog
implements TransactionLog {
    private final List<TransactionLog> logs = new ArrayList<TransactionLog>();

    public CompositeTransactionLog(Collection<TransactionLog> logs) throws TransactionLogException {
        this.logs.addAll(logs);
    }

    @Override
    public Set<String> getAddedList() throws TransactionLogException {
        HashSet<String> added = new HashSet<String>();
        for (TransactionLog log : this.logs) {
            added.addAll(log.getAddedList());
        }
        return added;
    }

    @Override
    public Set<String> getRemovedList() throws TransactionLogException {
        HashSet<String> removed = new HashSet<String>();
        for (TransactionLog log : this.logs) {
            removed.addAll(log.getRemovedList());
        }
        return removed;
    }

    @Override
    public void load() throws TransactionLogException {
        for (TransactionLog log : this.logs) {
            log.load();
        }
    }

    @Override
    public void log() throws TransactionLogException {
        throw new UnsupportedOperationException("CompositeTransactionLog do not support log() method.");
    }

    @Override
    public void removeLog() throws TransactionLogException {
        for (TransactionLog log : this.logs) {
            log.removeLog();
        }
    }
}

