/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.result;

import java.util.LinkedHashMap;
import java.util.Map;
import org.xcmis.search.SearchServiceException;
import org.xcmis.spi.utils.Logger;

public class ScoredRow {
    private final Logger log = Logger.getLogger((String)this.getClass().getName());
    private final Map<String, String> nodesMap;
    private final float score;

    public ScoredRow(Map<String, String> nodesMap, float score) {
        this.nodesMap = nodesMap;
        this.score = score;
    }

    public ScoredRow(String selectorName, String nodeIdentifer, float score) {
        this.nodesMap = new LinkedHashMap<String, String>();
        this.score = score;
        this.nodesMap.put(selectorName, nodeIdentifer);
    }

    public void addNode(String selectorName, String nodeIdentifer) {
        this.nodesMap.put(selectorName, nodeIdentifer);
    }

    public int getLength() {
        return this.nodesMap.size();
    }

    public String toString() {
        return "Score:" + this.score + " nodes" + this.nodesMap;
    }

    public String getNodeIdentifer(String selectorName) {
        return this.nodesMap.get(selectorName);
    }

    public float getScore() {
        return this.score;
    }

    public String[] getSelectorNames() {
        String[] result = new String[this.nodesMap.size()];
        this.nodesMap.keySet().toArray(result);
        return result;
    }

    public static ScoredRow merge(ScoredRow nodes1, ScoredRow nodes2, float newscore) throws SearchServiceException {
        LinkedHashMap<String, String> newNodesMap = new LinkedHashMap<String, String>();
        String[] names1 = nodes1.getSelectorNames();
        for (int i = 0; i < names1.length; ++i) {
            newNodesMap.put(names1[i], nodes1.getNodeIdentifer(names1[i]));
        }
        String[] names2 = nodes2.getSelectorNames();
        for (int i = 0; i < names1.length; ++i) {
            newNodesMap.put(names2[i], nodes2.getNodeIdentifer(names2[i]));
        }
        return new ScoredRow(newNodesMap, newscore);
    }
}

