/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

@Serialized
public class PasswordStringLengthValidator
implements Validator {
    private Integer min_ = 0;
    private Integer max_ = 0;

    public PasswordStringLengthValidator() {
    }

    public PasswordStringLengthValidator(Integer max) {
        this.max_ = max;
    }

    public PasswordStringLengthValidator(Integer min, Integer max) {
        this.min_ = min;
        this.max_ = max;
    }

    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        if (uiInput.getValue() != null) {
            int length = ((String)uiInput.getValue()).length();
            if (this.min_ <= length && this.max_ >= length) {
                return;
            }
        }
        UIComponent uiComponent = (UIComponent)uiInput;
        UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getId() + ".label." + uiInput.getName();
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        Object[] args = new Object[]{label, this.min_.toString(), this.max_.toString()};
        throw new MessageException(new ApplicationMessage("StringLengthValidator.msg.length-invalid", args, 1));
    }
}

