/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.exoplatform.common.http.client.AuthSchemeNotImplException;
import org.exoplatform.common.http.client.AuthorizationHandler;
import org.exoplatform.common.http.client.AuthorizationInfo;
import org.exoplatform.common.http.client.AuthorizationPrompter;
import org.exoplatform.common.http.client.Codecs;
import org.exoplatform.common.http.client.GlobalConstants;
import org.exoplatform.common.http.client.HttpHeaderElement;
import org.exoplatform.common.http.client.MD5;
import org.exoplatform.common.http.client.MD5InputStream;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.common.http.client.RoResponse;
import org.exoplatform.common.http.client.SimpleAuthPopup;
import org.exoplatform.common.http.client.SimpleAuthPrompt;
import org.exoplatform.common.http.client.URI;
import org.exoplatform.common.http.client.Util;
import org.exoplatform.common.http.client.VerifyDigest;
import org.exoplatform.common.http.client.VerifyRspAuth;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DefaultAuthHandler
implements AuthorizationHandler,
GlobalConstants {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.common.http.client.DefaultAuthHandler");
    private static final byte[] NUL = new byte[0];
    private static final int DI_A1 = 0;
    private static final int DI_A1S = 1;
    private static final int DI_QOP = 2;
    private static byte[] digest_secret = null;
    private static AuthorizationPrompter prompter = null;
    private static boolean prompterSet = false;
    private static final Log log = ExoLogger.getLogger((String)"exo.ws.commons.DefaultAuthHandler");

    public AuthorizationInfo fixupAuthInfo(AuthorizationInfo info, RoRequest req, AuthorizationInfo challenge, RoResponse resp) throws AuthSchemeNotImplException {
        if (info.getScheme().equalsIgnoreCase("Basic") || info.getScheme().equalsIgnoreCase("SOCKS5")) {
            return info;
        }
        if (!info.getScheme().equalsIgnoreCase("Digest")) {
            throw new AuthSchemeNotImplException(info.getScheme());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fixing up Authorization for host " + info.getHost() + ":" + info.getPort() + "; scheme: " + info.getScheme() + "; realm: " + info.getRealm()));
        }
        return DefaultAuthHandler.digest_fixup(info, req, challenge, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationInfo getAuthorization(AuthorizationInfo challenge, RoRequest req, RoResponse resp) throws AuthSchemeNotImplException, IOException {
        NVPair answer;
        AuthorizationInfo cred;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requesting Authorization for host " + challenge.getHost() + ":" + challenge.getPort() + "; scheme: " + challenge.getScheme() + "; realm: " + challenge.getRealm()));
        }
        if (!(challenge.getScheme().equalsIgnoreCase("Basic") || challenge.getScheme().equalsIgnoreCase("Digest") || challenge.getScheme().equalsIgnoreCase("SOCKS5"))) {
            throw new AuthSchemeNotImplException(challenge.getScheme());
        }
        if (challenge.getScheme().equalsIgnoreCase("Digest") && (cred = DefaultAuthHandler.digest_check_stale(challenge, req, resp)) != null) {
            return cred;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!req.allowUI() || prompterSet && prompter == null) {
                return null;
            }
            if (prompter == null) {
                DefaultAuthHandler.setDefaultPrompter();
            }
            answer = prompter.getUsernamePassword(challenge, resp.getStatusCode() == 407);
        }
        if (answer == null) {
            return null;
        }
        if (challenge.getScheme().equalsIgnoreCase("basic")) {
            cred = new AuthorizationInfo(challenge.getHost(), challenge.getPort(), challenge.getScheme(), challenge.getRealm(), Codecs.base64Encode(answer.getName() + ":" + answer.getValue()));
        } else if (challenge.getScheme().equalsIgnoreCase("Digest")) {
            cred = DefaultAuthHandler.digest_gen_auth_info(challenge.getHost(), challenge.getPort(), challenge.getRealm(), answer.getName(), answer.getValue(), req.getConnection().getContext());
            cred = DefaultAuthHandler.digest_fixup(cred, req, challenge, null);
        } else {
            NVPair[] upwd = new NVPair[]{answer};
            cred = new AuthorizationInfo(challenge.getHost(), challenge.getPort(), challenge.getScheme(), challenge.getRealm(), upwd, null);
        }
        answer = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Got Authorization");
        }
        return cred;
    }

    public void handleAuthHeaders(Response resp, RoRequest req, AuthorizationInfo prev, AuthorizationInfo prxy) throws IOException {
        String auth_info = resp.getHeader("Authentication-Info");
        String prxy_info = resp.getHeader("Proxy-Authentication-Info");
        if (auth_info == null && prev != null && DefaultAuthHandler.hasParam(prev.getParams(), "qop", "auth-int")) {
            auth_info = "";
        }
        if (prxy_info == null && prxy != null && DefaultAuthHandler.hasParam(prxy.getParams(), "qop", "auth-int")) {
            prxy_info = "";
        }
        try {
            DefaultAuthHandler.handleAuthInfo(auth_info, "Authentication-Info", prev, resp, req, true);
            DefaultAuthHandler.handleAuthInfo(prxy_info, "Proxy-Authentication-Info", prxy, resp, req, true);
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
    }

    public void handleAuthTrailers(Response resp, RoRequest req, AuthorizationInfo prev, AuthorizationInfo prxy) throws IOException {
        String auth_info = resp.getTrailer("Authentication-Info");
        String prxy_info = resp.getTrailer("Proxy-Authentication-Info");
        try {
            DefaultAuthHandler.handleAuthInfo(auth_info, "Authentication-Info", prev, resp, req, false);
            DefaultAuthHandler.handleAuthInfo(prxy_info, "Proxy-Authentication-Info", prxy, resp, req, false);
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
    }

    private static void handleAuthInfo(String auth_info, String hdr_name, AuthorizationInfo prev, Response resp, RoRequest req, boolean in_headers) throws ParseException, IOException {
        if (auth_info == null) {
            return;
        }
        Vector pai = Util.parseHeader(auth_info);
        HttpHeaderElement elem = Util.getElement(pai, "nextnonce");
        if (DefaultAuthHandler.handle_nextnonce(prev, req, elem)) {
            pai.removeElement(elem);
        }
        if (DefaultAuthHandler.handle_discard(prev, req, elem = Util.getElement(pai, "discard"))) {
            pai.removeElement(elem);
        }
        if (in_headers) {
            HttpHeaderElement qop = null;
            if (pai != null && (qop = Util.getElement(pai, "qop")) != null && qop.getValue() != null) {
                DefaultAuthHandler.handle_rspauth(prev, resp, req, pai, hdr_name);
            } else if (prev != null && (Util.hasToken(resp.getHeader("Trailer"), hdr_name) && DefaultAuthHandler.hasParam(prev.getParams(), "qop", null) || DefaultAuthHandler.hasParam(prev.getParams(), "qop", "auth-int"))) {
                DefaultAuthHandler.handle_rspauth(prev, resp, req, null, hdr_name);
            } else if (pai != null && qop == null && pai.contains(new HttpHeaderElement("digest")) || Util.hasToken(resp.getHeader("Trailer"), hdr_name) && prev != null && !DefaultAuthHandler.hasParam(prev.getParams(), "qop", null)) {
                DefaultAuthHandler.handle_digest(prev, resp, req, hdr_name);
            }
        }
        if (pai.size() > 0) {
            resp.setHeader(hdr_name, Util.assembleHeader(pai));
        } else {
            resp.deleteHeader(hdr_name);
        }
    }

    private static final boolean hasParam(NVPair[] params, String name, String val) {
        for (int idx = 0; idx < params.length; ++idx) {
            if (!params[idx].getName().equalsIgnoreCase(name) || val != null && !params[idx].getValue().equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    private static AuthorizationInfo digest_gen_auth_info(String host, int port, String realm, String user, String pass, Object context) {
        NVPair[] params;
        String A1 = user + ":" + realm + ":" + pass;
        String[] info = new String[]{MD5.hexDigest(A1), null, null};
        AuthorizationInfo prev = AuthorizationInfo.getAuthorization(host, port, "Digest", realm, context);
        if (prev == null) {
            params = new NVPair[]{new NVPair("username", user), new NVPair("uri", ""), new NVPair("nonce", ""), new NVPair("response", "")};
        } else {
            params = prev.getParams();
            for (int idx = 0; idx < params.length; ++idx) {
                if (!params[idx].getName().equalsIgnoreCase("username")) continue;
                params[idx] = new NVPair("username", user);
                break;
            }
        }
        return new AuthorizationInfo(host, port, "Digest", realm, params, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthorizationInfo digest_fixup(AuthorizationInfo info, RoRequest req, AuthorizationInfo challenge, RoResponse resp) throws AuthSchemeNotImplException {
        AuthorizationInfo tmp;
        boolean from_server;
        AuthorizationInfo new_info;
        String[] extra;
        NVPair[] params;
        int ch_domain = -1;
        int ch_nonce = -1;
        int ch_alg = -1;
        int ch_opaque = -1;
        int ch_stale = -1;
        int ch_dreq = -1;
        int ch_qop = -1;
        NVPair[] ch_params = null;
        if (challenge != null) {
            ch_params = challenge.getParams();
            for (int idx = 0; idx < ch_params.length; ++idx) {
                String name = ch_params[idx].getName().toLowerCase();
                if (name.equals("domain")) {
                    ch_domain = idx;
                    continue;
                }
                if (name.equals("nonce")) {
                    ch_nonce = idx;
                    continue;
                }
                if (name.equals("opaque")) {
                    ch_opaque = idx;
                    continue;
                }
                if (name.equals("algorithm")) {
                    ch_alg = idx;
                    continue;
                }
                if (name.equals("stale")) {
                    ch_stale = idx;
                    continue;
                }
                if (name.equals("digest-required")) {
                    ch_dreq = idx;
                    continue;
                }
                if (!name.equals("qop")) continue;
                ch_qop = idx;
            }
        }
        int uri = -1;
        int user = -1;
        int alg = -1;
        int response = -1;
        int nonce = -1;
        int cnonce = -1;
        int nc = -1;
        int opaque = -1;
        int digest = -1;
        int dreq = -1;
        int qop = -1;
        AuthorizationInfo authorizationInfo = info;
        synchronized (authorizationInfo) {
            params = info.getParams();
            for (int idx = 0; idx < params.length; ++idx) {
                String name = params[idx].getName().toLowerCase();
                if (name.equals("uri")) {
                    uri = idx;
                    continue;
                }
                if (name.equals("username")) {
                    user = idx;
                    continue;
                }
                if (name.equals("algorithm")) {
                    alg = idx;
                    continue;
                }
                if (name.equals("nonce")) {
                    nonce = idx;
                    continue;
                }
                if (name.equals("cnonce")) {
                    cnonce = idx;
                    continue;
                }
                if (name.equals("nc")) {
                    nc = idx;
                    continue;
                }
                if (name.equals("response")) {
                    response = idx;
                    continue;
                }
                if (name.equals("opaque")) {
                    opaque = idx;
                    continue;
                }
                if (name.equals("digest")) {
                    digest = idx;
                    continue;
                }
                if (name.equals("digest-required")) {
                    dreq = idx;
                    continue;
                }
                if (!name.equals("qop")) continue;
                qop = idx;
            }
            extra = (String[])info.getExtraInfo();
            if (alg != -1 && !params[alg].getValue().equalsIgnoreCase("MD5") && !params[alg].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + params[alg].getValue() + " not implemented");
            }
            if (ch_alg != -1 && !ch_params[ch_alg].getValue().equalsIgnoreCase("MD5") && !ch_params[ch_alg].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + ch_params[ch_alg].getValue() + " not implemented");
            }
            params[uri] = new NVPair("uri", URI.escape(req.getRequestURI(), URI.escpdPathChar, false));
            String old_nonce = params[nonce].getValue();
            if (ch_nonce != -1 && !old_nonce.equals(ch_params[ch_nonce].getValue())) {
                params[nonce] = ch_params[ch_nonce];
            }
            if (ch_opaque != -1) {
                if (opaque == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    opaque = params.length - 1;
                }
                params[opaque] = ch_params[ch_opaque];
            }
            if (ch_alg != -1) {
                if (alg == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    alg = params.length - 1;
                }
                params[alg] = ch_params[ch_alg];
            }
            if (ch_qop != -1 || ch_alg != -1 && ch_params[ch_alg].getValue().equalsIgnoreCase("MD5-sess")) {
                if (cnonce == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    cnonce = params.length - 1;
                }
                if (digest_secret == null) {
                    digest_secret = DefaultAuthHandler.gen_random_bytes(20);
                }
                long l_time = System.currentTimeMillis();
                byte[] time = new byte[]{(byte)(l_time & 0xFFL), (byte)(l_time >> 8 & 0xFFL), (byte)(l_time >> 16 & 0xFFL), (byte)(l_time >> 24 & 0xFFL), (byte)(l_time >> 32 & 0xFFL), (byte)(l_time >> 40 & 0xFFL), (byte)(l_time >> 48 & 0xFFL), (byte)(l_time >> 56 & 0xFFL)};
                params[cnonce] = new NVPair("cnonce", MD5.hexDigest(digest_secret, time));
            }
            if (ch_qop != -1) {
                int idx;
                if (qop == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    qop = params.length - 1;
                }
                extra[2] = ch_params[ch_qop].getValue();
                String[] qops = DefaultAuthHandler.splitList(extra[2], ",");
                String p = null;
                for (idx = 0; idx < qops.length; ++idx) {
                    if (qops[idx].equalsIgnoreCase("auth-int") && (req.getStream() == null || req.getConnection().ServProtVersKnown && req.getConnection().ServerProtocolVersion >= 65537)) {
                        p = "auth-int";
                        break;
                    }
                    if (!qops[idx].equalsIgnoreCase("auth")) continue;
                    p = "auth";
                }
                if (p == null) {
                    for (idx = 0; idx < qops.length; ++idx) {
                        if (!qops[idx].equalsIgnoreCase("auth-int")) continue;
                        throw new AuthSchemeNotImplException("Digest auth scheme: Can't comply with qop option 'auth-int' because an HttpOutputStream is being used and the server doesn't speak HTTP/1.1");
                    }
                    throw new AuthSchemeNotImplException("Digest auth scheme: None of the available qop options '" + ch_params[ch_qop].getValue() + "' implemented");
                }
                params[qop] = new NVPair("qop", p);
            }
            if (qop != -1) {
                if (nc == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    nc = params.length - 1;
                    params[nc] = new NVPair("nc", "00000001");
                } else if (old_nonce.equals(params[nonce].getValue())) {
                    String c = Long.toHexString(Long.parseLong(params[nc].getValue(), 16) + 1L);
                    params[nc] = new NVPair("nc", "00000000".substring(c.length()) + c);
                } else {
                    params[nc] = new NVPair("nc", "00000001");
                }
            }
            if (challenge != null && (ch_stale == -1 || !ch_params[ch_stale].getValue().equalsIgnoreCase("true")) && alg != -1 && params[alg].getValue().equalsIgnoreCase("MD5-sess")) {
                extra[1] = MD5.hexDigest(extra[0] + ":" + params[nonce].getValue() + ":" + params[cnonce].getValue());
            }
            info.setParams(params);
            info.setExtraInfo(extra);
        }
        String hash = null;
        if (qop != -1 && params[qop].getValue().equalsIgnoreCase("auth-int") && req.getStream() == null) {
            hash = MD5.hexDigest(req.getData() == null ? NUL : req.getData());
        }
        if (req.getStream() == null) {
            params[response] = new NVPair("response", DefaultAuthHandler.calcResponseAttr(hash, extra, params, alg, uri, qop, nonce, nc, cnonce, req.getMethod()));
        }
        boolean ch_dreq_val = false;
        if (ch_dreq != -1 && (ch_params[ch_dreq].getValue() == null || ch_params[ch_dreq].getValue().equalsIgnoreCase("true"))) {
            ch_dreq_val = true;
        }
        if ((ch_dreq_val || digest != -1) && req.getStream() == null) {
            NVPair[] d_params;
            if (digest == -1) {
                d_params = Util.resizeArray(params, params.length + 1);
                digest = params.length;
            } else {
                d_params = params;
            }
            d_params[digest] = new NVPair("digest", DefaultAuthHandler.calc_digest(req, extra[0], params[nonce].getValue()));
            if (dreq == -1) {
                dreq = d_params.length;
                d_params = Util.resizeArray(d_params, d_params.length + 1);
                d_params[dreq] = new NVPair("digest-required", "true");
            }
            new_info = new AuthorizationInfo(info.getHost(), info.getPort(), info.getScheme(), info.getRealm(), d_params, extra);
        } else {
            new_info = ch_dreq_val ? null : new AuthorizationInfo(info.getHost(), info.getPort(), info.getScheme(), info.getRealm(), params, extra);
        }
        boolean bl = from_server = challenge != null && challenge.getHost().equalsIgnoreCase(req.getConnection().getHost());
        if (ch_domain != -1) {
            URI base = null;
            try {
                base = new URI(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort(), req.getRequestURI());
            }
            catch (ParseException pe) {
                // empty catch block
            }
            StringTokenizer tok = new StringTokenizer(ch_params[ch_domain].getValue());
            while (tok.hasMoreTokens()) {
                URI Uri;
                try {
                    Uri = new URI(base, tok.nextToken());
                }
                catch (ParseException pe) {
                    continue;
                }
                if (Uri.getHost() == null) continue;
                AuthorizationInfo tmp2 = AuthorizationInfo.getAuthorization(Uri.getHost(), Uri.getPort(), info.getScheme(), info.getRealm(), req.getConnection().getContext());
                if (tmp2 == null) {
                    params[uri] = new NVPair("uri", Uri.getPathAndQuery());
                    tmp2 = new AuthorizationInfo(Uri.getHost(), Uri.getPort(), info.getScheme(), info.getRealm(), params, extra);
                    AuthorizationInfo.addAuthorization(tmp2);
                }
                if (!from_server) continue;
                tmp2.addPath(Uri.getPathAndQuery());
            }
        } else if (from_server && challenge != null && (tmp = AuthorizationInfo.getAuthorization(challenge.getHost(), challenge.getPort(), info.getScheme(), info.getRealm(), req.getConnection().getContext())) != null) {
            tmp.addPath("/");
        }
        return new_info;
    }

    private static AuthorizationInfo digest_check_stale(AuthorizationInfo challenge, RoRequest req, RoResponse resp) throws AuthSchemeNotImplException, IOException {
        AuthorizationInfo cred = null;
        NVPair[] params = challenge.getParams();
        for (int idx = 0; idx < params.length; ++idx) {
            String name = params[idx].getName();
            if (!name.equalsIgnoreCase("stale") || !params[idx].getValue().equalsIgnoreCase("true")) continue;
            cred = AuthorizationInfo.getAuthorization(challenge, req, resp, false);
            if (cred == null) break;
            return DefaultAuthHandler.digest_fixup(cred, req, challenge, resp);
        }
        return cred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handle_nextnonce(AuthorizationInfo prev, RoRequest req, HttpHeaderElement nextnonce) throws IOException {
        AuthorizationInfo ai;
        if (prev == null || nextnonce == null || nextnonce.getValue() == null) {
            return false;
        }
        try {
            ai = AuthorizationInfo.getAuthorization(prev, req, null, false);
        }
        catch (AuthSchemeNotImplException asnie) {
            ai = prev;
        }
        AuthorizationInfo authorizationInfo = ai;
        synchronized (authorizationInfo) {
            NVPair[] params = ai.getParams();
            params = DefaultAuthHandler.setValue(params, "nonce", nextnonce.getValue());
            params = DefaultAuthHandler.setValue(params, "nc", "00000000");
            ai.setParams(params);
        }
        return true;
    }

    private static boolean handle_digest(AuthorizationInfo prev, Response resp, RoRequest req, String hdr_name) throws IOException {
        if (prev == null) {
            return false;
        }
        NVPair[] params = prev.getParams();
        VerifyDigest verifier = new VerifyDigest(((String[])prev.getExtraInfo())[0], DefaultAuthHandler.getValue(params, "nonce"), req.getMethod(), DefaultAuthHandler.getValue(params, "uri"), hdr_name, resp);
        if (resp.hasEntity()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pushing md5-check-stream to verify digest from " + hdr_name));
            }
            resp.inp_stream = new MD5InputStream(resp.inp_stream, verifier);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Verifying digest from " + hdr_name));
            }
            verifier.verifyHash(MD5.digest(NUL), 0L);
        }
        return true;
    }

    private static boolean handle_rspauth(AuthorizationInfo prev, Response resp, RoRequest req, Vector auth_info, String hdr_name) throws IOException {
        if (prev == null) {
            return false;
        }
        NVPair[] params = prev.getParams();
        int uri = -1;
        int alg = -1;
        int nonce = -1;
        int cnonce = -1;
        int nc = -1;
        for (int idx = 0; idx < params.length; ++idx) {
            String name = params[idx].getName().toLowerCase();
            if (name.equals("uri")) {
                uri = idx;
                continue;
            }
            if (name.equals("algorithm")) {
                alg = idx;
                continue;
            }
            if (name.equals("nonce")) {
                nonce = idx;
                continue;
            }
            if (name.equals("cnonce")) {
                cnonce = idx;
                continue;
            }
            if (!name.equals("nc")) continue;
            nc = idx;
        }
        VerifyRspAuth verifier = new VerifyRspAuth(params[uri].getValue(), ((String[])prev.getExtraInfo())[0], alg == -1 ? null : params[alg].getValue(), params[nonce].getValue(), cnonce == -1 ? "" : params[cnonce].getValue(), nc == -1 ? "" : params[nc].getValue(), hdr_name, resp);
        HttpHeaderElement qop = null;
        if (auth_info != null && (qop = Util.getElement(auth_info, "qop")) != null && qop.getValue() != null && (qop.getValue().equalsIgnoreCase("auth") || !resp.hasEntity() && qop.getValue().equalsIgnoreCase("auth-int"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Verifying rspauth from " + hdr_name));
            }
            verifier.verifyHash(MD5.digest(NUL), 0L);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pushing md5-check-stream to verify rspauth from " + hdr_name));
            }
            resp.inp_stream = new MD5InputStream(resp.inp_stream, verifier);
        }
        return true;
    }

    private static String calcResponseAttr(String hash, String[] extra, NVPair[] params, int alg, int uri, int qop, int nonce, int nc, int cnonce, String method) {
        String A1 = alg != -1 && params[alg].getValue().equalsIgnoreCase("MD5-sess") ? extra[1] : extra[0];
        String A2 = method + ":" + params[uri].getValue();
        if (qop != -1 && params[qop].getValue().equalsIgnoreCase("auth-int")) {
            A2 = A2 + ":" + hash;
        }
        A2 = MD5.hexDigest(A2);
        String resp_val = qop == -1 ? MD5.hexDigest(A1 + ":" + params[nonce].getValue() + ":" + A2) : MD5.hexDigest(A1 + ":" + params[nonce].getValue() + ":" + params[nc].getValue() + ":" + params[cnonce].getValue() + ":" + params[qop].getValue() + ":" + A2);
        return resp_val;
    }

    private static String calc_digest(RoRequest req, String A1_hash, String nonce) {
        if (req.getStream() != null) {
            return "";
        }
        int ct = -1;
        int ce = -1;
        int lm = -1;
        int ex = -1;
        int dt = -1;
        for (int idx = 0; idx < req.getHeaders().length; ++idx) {
            String name = req.getHeaders()[idx].getName();
            if (name.equalsIgnoreCase("Content-type")) {
                ct = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Content-Encoding")) {
                ce = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Last-Modified")) {
                lm = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Expires")) {
                ex = idx;
                continue;
            }
            if (!name.equalsIgnoreCase("Date")) continue;
            dt = idx;
        }
        NVPair[] hdrs = req.getHeaders();
        byte[] entity_body = req.getData() == null ? NUL : req.getData();
        String entity_hash = MD5.hexDigest(entity_body);
        String entity_info = MD5.hexDigest(req.getRequestURI() + ":" + (ct == -1 ? "" : hdrs[ct].getValue()) + ":" + entity_body.length + ":" + (ce == -1 ? "" : hdrs[ce].getValue()) + ":" + (lm == -1 ? "" : hdrs[lm].getValue()) + ":" + (ex == -1 ? "" : hdrs[ex].getValue()));
        String entity_digest = A1_hash + ":" + nonce + ":" + req.getMethod() + ":" + (dt == -1 ? "" : hdrs[dt].getValue()) + ":" + entity_info + ":" + entity_hash;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entity-Info: '" + req.getRequestURI() + ":" + (ct == -1 ? "" : hdrs[ct].getValue()) + ":" + entity_body.length + ":" + (ce == -1 ? "" : hdrs[ce].getValue()) + ":" + (lm == -1 ? "" : hdrs[lm].getValue()) + ":" + (ex == -1 ? "" : hdrs[ex].getValue()) + "'"));
            log.debug((Object)("Entity-Body: '" + entity_hash + "'"));
            log.debug((Object)("Entity-Digest: '" + entity_digest + "'"));
        }
        return MD5.hexDigest(entity_digest);
    }

    private static boolean handle_discard(AuthorizationInfo prev, RoRequest req, HttpHeaderElement discard) {
        if (discard != null && prev != null) {
            AuthorizationInfo.removeAuthorization(prev, req.getConnection().getContext());
            return true;
        }
        return false;
    }

    private static byte[] gen_random_bytes(int num) {
        try {
            FileInputStream rnd = new FileInputStream("/dev/random");
            DataInputStream din = new DataInputStream(rnd);
            byte[] data = new byte[num];
            din.readFully(data);
            try {
                din.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return data;
        }
        catch (Throwable t) {
            byte[] data = new byte[num];
            try {
                long fm = Runtime.getRuntime().freeMemory();
                data[0] = (byte)(fm & 0xFFL);
                data[1] = (byte)(fm >> 8 & 0xFFL);
                int h = data.hashCode();
                data[2] = (byte)(h & 0xFF);
                data[3] = (byte)(h >> 8 & 0xFF);
                data[4] = (byte)(h >> 16 & 0xFF);
                data[5] = (byte)(h >> 24 & 0xFF);
                long time = System.currentTimeMillis();
                data[6] = (byte)(time & 0xFFL);
                data[7] = (byte)(time >> 8 & 0xFFL);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return data;
        }
    }

    private static final String getValue(NVPair[] list, String key) {
        int len = list.length;
        for (int idx = 0; idx < len; ++idx) {
            if (!list[idx].getName().equalsIgnoreCase(key)) continue;
            return list[idx].getValue();
        }
        return null;
    }

    private static final int getIndex(NVPair[] list, String key) {
        int len = list.length;
        for (int idx = 0; idx < len; ++idx) {
            if (!list[idx].getName().equalsIgnoreCase(key)) continue;
            return idx;
        }
        return -1;
    }

    private static final NVPair[] setValue(NVPair[] list, String key, String val) {
        int idx = DefaultAuthHandler.getIndex(list, key);
        if (idx == -1) {
            idx = list.length;
            list = Util.resizeArray(list, list.length + 1);
        }
        list[idx] = new NVPair(key, val);
        return list;
    }

    private static String[] splitList(String str, String sep) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(str, sep);
        String[] list = new String[tok.countTokens()];
        for (int idx = 0; idx < list.length; ++idx) {
            list[idx] = tok.nextToken().trim();
        }
        return list;
    }

    static String hex(byte[] buf) {
        StringBuffer str = new StringBuffer(buf.length * 3);
        for (int idx = 0; idx < buf.length; ++idx) {
            str.append(Character.forDigit(buf[idx] >> 4 & 0xF, 16));
            str.append(Character.forDigit(buf[idx] & 0xF, 16));
            str.append(':');
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }

    static final byte[] unHex(String hex) {
        byte[] digest = new byte[hex.length() / 2];
        for (int idx = 0; idx < digest.length; ++idx) {
            digest[idx] = (byte)(0xFF & Integer.parseInt(hex.substring(2 * idx, 2 * (idx + 1)), 16));
        }
        return digest;
    }

    public static synchronized AuthorizationPrompter setAuthorizationPrompter(AuthorizationPrompter prompt) {
        AuthorizationPrompter prev = prompter;
        prompter = prompt;
        prompterSet = true;
        return prev;
    }

    private static void setDefaultPrompter() {
        prompter = !SimpleAuthPrompt.canUseCLPrompt() || DefaultAuthHandler.isAWTRunning() ? new SimpleAuthPopup() : new SimpleAuthPrompt();
    }

    private static final boolean isAWTRunning() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Thread[] t_list = new Thread[root.activeCount() + 5];
        int t_num = root.enumerate(t_list);
        for (int idx = 0; idx < t_num; ++idx) {
            if (!t_list[idx].getName().startsWith("AWT-")) continue;
            return true;
        }
        return false;
    }
}

