/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.IndexRecovery;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.PropertyTypeRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneVirtualTableResolver;
import org.exoplatform.services.rpc.RPCService;

public class QueryHandlerContext {
    private final ItemDataConsumer stateMgr;
    private final NodeTypeDataManager nodeTypeDataManager;
    private final NamespaceRegistryImpl nsRegistry;
    private final IndexingTree indexingTree;
    private final PropertyTypeRegistry propRegistry;
    private final QueryHandler parentHandler;
    private final DocumentReaderService extractor;
    private final String indexDirectory;
    private final boolean createInitialIndex;
    private final boolean recoveryFilterUsed;
    private final LuceneVirtualTableResolver virtualTableResolver;
    private final WorkspaceContainerFacade container;
    private final IndexRecovery indexRecovery;
    private final RPCService rpcService;
    private final String repositoryName;
    private final String workspaceName;

    public QueryHandlerContext(WorkspaceContainerFacade container, ItemDataConsumer stateMgr, IndexingTree indexingTree, NodeTypeDataManager nodeTypeDataManager, NamespaceRegistryImpl nsRegistry, QueryHandler parentHandler, String indexDirectory, DocumentReaderService extractor, boolean createInitialIndex, boolean useIndexRecoveryFilters, LuceneVirtualTableResolver virtualTableResolver, IndexRecovery indexRecovery, RPCService rpcService, String repositoryName, String workspaceName) {
        this.indexRecovery = indexRecovery;
        this.container = container;
        this.stateMgr = stateMgr;
        this.indexingTree = indexingTree;
        this.nodeTypeDataManager = nodeTypeDataManager;
        this.nsRegistry = nsRegistry;
        this.indexDirectory = indexDirectory;
        this.extractor = extractor;
        this.createInitialIndex = createInitialIndex;
        this.virtualTableResolver = virtualTableResolver;
        this.propRegistry = new PropertyTypeRegistry(nodeTypeDataManager);
        this.rpcService = rpcService;
        this.parentHandler = parentHandler;
        this.repositoryName = repositoryName;
        this.workspaceName = workspaceName;
        this.recoveryFilterUsed = useIndexRecoveryFilters;
        ((NodeTypeDataManagerImpl)this.nodeTypeDataManager).addListener(this.propRegistry);
    }

    public WorkspaceContainerFacade getContainer() {
        return this.container;
    }

    public LuceneVirtualTableResolver getVirtualTableResolver() {
        return this.virtualTableResolver;
    }

    public boolean isCreateInitialIndex() {
        return this.createInitialIndex;
    }

    public boolean isRecoveryFilterUsed() {
        return this.recoveryFilterUsed;
    }

    public ItemDataConsumer getItemStateManager() {
        return this.stateMgr;
    }

    public IndexingTree getIndexingTree() {
        return this.indexingTree;
    }

    public PropertyTypeRegistry getPropertyTypeRegistry() {
        return this.propRegistry;
    }

    public NodeTypeDataManager getNodeTypeDataManager() {
        return this.nodeTypeDataManager;
    }

    public NamespaceRegistryImpl getNamespaceRegistry() {
        return this.nsRegistry;
    }

    public QueryHandler getParentHandler() {
        return this.parentHandler;
    }

    public void destroy() {
        ((NodeTypeDataManagerImpl)this.nodeTypeDataManager).removeListener(this.propRegistry);
    }

    public DocumentReaderService getExtractor() {
        return this.extractor;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public IndexRecovery getIndexRecovery() {
        return this.indexRecovery;
    }

    public RPCService getRPCService() {
        return this.rpcService;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getWorkspacePath(boolean includeSystemMark) {
        return this.repositoryName + "/" + this.workspaceName + (includeSystemMark && this.parentHandler == null ? "[system]" : "");
    }
}

