/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.inmemory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLHolder;
import org.exoplatform.services.jcr.impl.storage.inmemory.WorkspaceContainerRegistry;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InmemoryStorageConnection
implements WorkspaceStorageConnection {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.InmemoryStorageConnection");
    private TreeMap items;
    private TreeMap identifiers;

    InmemoryStorageConnection(String name) {
        this.items = WorkspaceContainerRegistry.getInstance().getWorkspaceContainer(name);
        this.identifiers = new TreeMap();
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException, IllegalStateException {
        return this.getItemData(parentData, name, ItemType.UNKNOWN);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException, IllegalStateException {
        ItemData itemData = null;
        QPath qPath = QPath.makeChildPath(parentData.getQPath(), name);
        if (itemType == ItemType.NODE || itemType == ItemType.UNKNOWN) {
            itemData = (ItemData)this.items.get(new MapKey(qPath, ItemType.NODE));
        }
        if (itemType == ItemType.PROPERTY || itemType == ItemType.UNKNOWN && itemData == null) {
            itemData = (ItemData)this.items.get(new MapKey(qPath, ItemType.PROPERTY));
        }
        return itemData;
    }

    public ItemData getItemData(QPath qPath) throws RepositoryException, IllegalStateException {
        log.debug((Object)("InmemoryContainer finding " + qPath.getAsString()));
        Object o = this.items.get(new MapKey(qPath, ItemType.NODE));
        if (o == null) {
            o = this.items.get(new MapKey(qPath, ItemType.PROPERTY));
        }
        log.debug((Object)("InmemoryContainer FOUND " + qPath.getAsString() + " " + o));
        return (ItemData)o;
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException, IllegalStateException {
        for (ItemData data : this.items.values()) {
            if (!data.getIdentifier().equals(identifier)) continue;
            return data;
        }
        return null;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        return null;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        return this.getChildNodesData(parent);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        return null;
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        return this.getChildPropertiesData(parent);
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        return null;
    }

    @Override
    public int getLastOrderNumber(NodeData nodeData) throws RepositoryException {
        return -1;
    }

    @Override
    public int getChildNodesCount(NodeData nodeData) throws RepositoryException {
        return 0;
    }

    public int getChildPropertiesCount(NodeData nodeData) throws RepositoryException {
        return 0;
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier) throws RepositoryException, IllegalStateException {
        ArrayList<PropertyData> refs = new ArrayList<PropertyData>();
        for (ItemData itemData : this.items.values()) {
            ValueData identifierVal = ((PropertyData)itemData).getValues().get(0);
            try {
                if (!(itemData instanceof PropertyData) || ((PropertyData)itemData).getType() != 9 || !new String(identifierVal.getAsByteArray()).equals(identifier)) continue;
                refs.add((PropertyData)itemData);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return refs;
    }

    @Override
    public void add(NodeData item) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        if (this.items.get(new MapKey(item.getQPath(), ItemType.getItemType(item))) != null) {
            throw new ItemExistsException("WorkspaceContainerImpl.add(Item) item '" + item.getQPath().getAsString() + "' already exists!");
        }
        this.items.put(new MapKey(item.getQPath(), ItemType.getItemType(item)), item);
        log.debug((Object)("InmemoryContainer added node " + item.getQPath().getAsString()));
        Iterator props = this.getChildProperties(item).iterator();
        while (props.hasNext()) {
            this.add((PropertyData)props.next());
        }
        Iterator nodes = this.getChildNodes(item).iterator();
        while (nodes.hasNext()) {
            this.add((NodeData)nodes.next());
        }
    }

    @Override
    public void add(PropertyData prop) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.items.put(new MapKey(prop.getQPath(), ItemType.getItemType(prop)), prop);
        log.debug((Object)("InmemoryContainer added property " + prop.getQPath().getAsString()));
    }

    @Override
    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void reindex(NodeData oldData, NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void update(PropertyData item) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.items.put(new MapKey(item.getQPath(), ItemType.getItemType(item)), item);
        log.debug((Object)("InmemoryContainer updated " + item));
    }

    @Override
    public void delete(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.items.remove(new MapKey(data.getQPath(), ItemType.getItemType(data)));
        log.debug((Object)("InmemoryContainer removed " + data.getQPath().getAsString()));
    }

    @Override
    public void delete(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.items.remove(new MapKey(data.getQPath(), ItemType.getItemType(data)));
        log.debug((Object)("InmemoryContainer removed " + data.getQPath().getAsString()));
    }

    @Override
    public void commit() throws IllegalStateException, RepositoryException {
    }

    @Override
    public void rollback() throws IllegalStateException, RepositoryException {
    }

    @Override
    public void close() throws IllegalStateException, RepositoryException {
    }

    @Override
    public boolean isOpened() {
        return false;
    }

    protected List getChildProperties(NodeData node) {
        return null;
    }

    protected List getChildNodes(NodeData node) {
        return null;
    }

    public String dump() {
        String str = "Inmemory WorkspaceContainer Data: \n";
        for (MapKey d : this.items.keySet()) {
            str = str + d.getQPath().getAsString() + '\t' + d.getItemType().toString() + "\n";
        }
        return str;
    }

    @Override
    public void rename(NodeData destData) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ACLHolder> getACLHolders() throws RepositoryException, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueData getValue(String propertyId, int orderNumb, int persistedVersion) throws IllegalStateException, RepositoryException {
        return null;
    }

    @Override
    public boolean getChildNodesDataByPage(NodeData parent, int fromOrderNum, int limit, List<NodeData> childs) throws RepositoryException {
        throw new UnsupportedOperationException("The method getChildNodesDataLazily is supported only for JDBCStorageConnection");
    }

    class MapKey {
        private final QPath path;
        private final String key;
        private final ItemType itemType;

        MapKey(QPath path, ItemType itemType) {
            this.path = path;
            this.itemType = itemType;
            this.key = this.key(this.path, this.itemType);
        }

        protected String key(QPath path, ItemType itemType) {
            StringBuilder sk = new StringBuilder();
            sk.append(path.getAsString());
            sk.append(itemType.toString());
            return sk.toString();
        }

        public boolean equals(Object obj) {
            if (this.key.hashCode() == obj.hashCode() && obj instanceof MapKey) {
                return this.key.equals(((MapKey)obj).key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        QPath getQPath() {
            return this.path;
        }

        ItemType getItemType() {
            return this.itemType;
        }
    }
}

