/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.ValueOperation;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileLockException;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileIOHelper;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueLockSupport;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class ValueFileOperation
extends ValueFileIOHelper
implements ValueOperation {
    public static final String TEMP_FILE_EXTENSION = ".temp";
    public static final String LOCK_FILE_EXTENSION = ".lock";
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ValueFileOperation");
    private static String LOCAL_ADDRESS;
    protected final FileCleaner cleaner;
    protected final ValueDataResourceHolder resources;
    protected final String operationInfo;
    protected final File tempDir;
    private boolean performed = false;

    ValueFileOperation(ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir) {
        this.cleaner = cleaner;
        this.resources = resources;
        this.tempDir = tempDir;
        this.operationInfo = System.currentTimeMillis() + " " + LOCAL_ADDRESS;
    }

    protected boolean isPerformed() {
        return this.performed;
    }

    protected void makePerformed() throws IOException {
        if (this.performed) {
            throw new IOException("Operation cannot be performed twice");
        }
        this.performed = true;
    }

    static {
        try {
            InetAddress local = InetAddress.getLocalHost();
            LOCAL_ADDRESS = local.getHostAddress() + " (" + local.getHostName() + ")";
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)("Cannot read host address " + e));
            LOCAL_ADDRESS = "no address, " + e;
        }
    }

    class ValueFileLock {
        private final File file;

        ValueFileLock(File file) {
            this.file = file;
        }

        public boolean lock() throws IOException {
            try {
                return ValueFileOperation.this.resources.aquire(this.file.getAbsolutePath(), new ValueFileLockHolder(this.file));
            }
            catch (InterruptedException e) {
                throw new FileLockException("Lock error on " + this.file.getAbsolutePath(), e);
            }
        }

        public boolean unlock() throws IOException {
            return ValueFileOperation.this.resources.release(this.file.getAbsolutePath());
        }
    }

    class ValueFileLockHolder
    implements ValueLockSupport {
        private final File targetFile;
        private File lockFile;
        private FileOutputStream lockFileStream;

        ValueFileLockHolder(File file) {
            this.targetFile = file;
        }

        public void lock() throws IOException {
            this.lockFile = new File(ValueFileOperation.this.tempDir, this.targetFile.getName() + ValueFileOperation.LOCK_FILE_EXTENSION);
            FileOutputStream lout = new FileOutputStream(this.lockFile, true);
            lout.write(ValueFileOperation.this.operationInfo.getBytes());
            lout.getChannel().lock();
            this.lockFileStream = lout;
        }

        public void share(ValueLockSupport anotherLock) throws IOException {
            if (!(anotherLock instanceof ValueFileLockHolder)) {
                throw new IOException("Cannot share lock with " + anotherLock.getClass());
            }
            ValueFileLockHolder al = (ValueFileLockHolder)anotherLock;
            this.lockFile = al.lockFile;
            this.lockFileStream = al.lockFileStream;
        }

        public void unlock() throws IOException {
            if (this.lockFileStream != null) {
                this.lockFileStream.close();
            }
            if (!this.lockFile.delete()) {
                LOG.warn((Object)("Cannot delete lock file " + this.lockFile.getAbsolutePath() + ". Add to the FileCleaner"));
                ValueFileOperation.this.cleaner.addFile(this.lockFile);
            }
        }
    }
}

