/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.platform;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/managedocument/")
public class ManageDocumentService
implements ResourceContainer {
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private final CacheControl cc = new CacheControl();
    private static Log log = ExoLogger.getLogger(ManageDocumentService.class);

    public ManageDocumentService(InitParams params) {
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getFoldersAndFiles(@QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodePath") String nodePath, @QueryParam(value="isFolderOnly") boolean isFolderOnly) {
        try {
            Node node = this.getNode(workspaceName, nodePath);
            return this.buildXMLResponseForChildren(node, isFolderOnly);
        }
        catch (AccessDeniedException e) {
            log.debug((Object)"Access is denied when perform get Folders and files: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            log.debug((Object)"Item is not found: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            log.error((Object)"Repository is error: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform get Folders and files: ", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/deleteFolderOrFile/")
    public Response deleteFolderOrFile(@QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodePath") String nodePath) {
        try {
            Node node = this.getNode(workspaceName, nodePath);
            Node parent = node.getParent();
            node.remove();
            parent.save();
            return Response.ok().cacheControl(this.cc).build();
        }
        catch (AccessDeniedException e) {
            log.debug((Object)"Access is denied when perform delete folder or file: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            log.debug((Object)"Item is not found: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            log.error((Object)"Repository is error: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform delete Folder or file: ", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/createFolder/")
    public Response createFolder(@QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="parentPath") String parentPath, @QueryParam(value="folderName") String folderName) throws Exception {
        try {
            Node node = this.getNode(workspaceName, parentPath);
            Node newNode = node.addNode(Text.escapeIllegalJcrChars((String)folderName), "nt:unstructured");
            node.save();
            Document document = this.createNewDocument();
            Element folderNode = this.createFolderElement(document, newNode, workspaceName);
            document.appendChild(folderNode);
            return this.getResponse(document);
        }
        catch (AccessDeniedException e) {
            log.debug((Object)"Access is denied when perform create folder: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            log.debug((Object)"Item is not found: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            log.error((Object)"Repository is error: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform create folder: ", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    private Response buildXMLResponseForChildren(Node node, boolean isFolderOnly) throws Exception {
        Session session = node.getSession();
        String workspaceName = session.getWorkspace().getName();
        Document document = this.createNewDocument();
        Element rootElement = this.createFolderElement(document, node, workspaceName);
        Element folders = document.createElement("Folders");
        Element files = document.createElement("Files");
        Node sourceNode = null;
        Node referNode = null;
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:symlink") && child.hasProperty("exo:uuid") && child.hasProperty("exo:workspace")) {
                String sourceWs = child.getProperty("exo:workspace").getString();
                Session sourceSession = this.getSession(sourceWs);
                sourceNode = sourceSession.getNodeByUUID(child.getProperty("exo:uuid").getString());
            }
            Node node2 = referNode = sourceNode != null ? sourceNode : child;
            if (this.isFolder(referNode)) {
                Element folder = this.createFolderElement(document, referNode, referNode.getSession().getWorkspace().getName());
                folders.appendChild(folder);
                continue;
            }
            if (!this.isFile(referNode)) continue;
            Element file = this.createFileElement(document, referNode, child, referNode.getSession().getWorkspace().getName());
            files.appendChild(file);
        }
        rootElement.appendChild(folders);
        if (!isFolderOnly) {
            rootElement.appendChild(files);
        }
        document.appendChild(rootElement);
        return this.getResponse(document);
    }

    private boolean isFolder(Node checkNode) throws RepositoryException {
        return checkNode.isNodeType("nt:folder") || checkNode.isNodeType("nt:unstructured");
    }

    private boolean isFile(Node checkNode) throws RepositoryException {
        return checkNode.isNodeType("nt:file");
    }

    private Element createFolderElement(Document document, Node child, String workspaceName) throws Exception {
        Element folder = document.createElement("Folder");
        boolean hasChild = false;
        NodeIterator iterator = child.getNodes();
        while (iterator.hasNext()) {
            if (!this.isFolder(iterator.nextNode())) continue;
            hasChild = true;
            break;
        }
        folder.setAttribute("name", child.getName());
        folder.setAttribute("folderType", child.getPrimaryNodeType().getName());
        folder.setAttribute("path", child.getPath());
        folder.setAttribute("workspaceName", workspaceName);
        folder.setAttribute("hasChild", String.valueOf(hasChild));
        return folder;
    }

    private Element createFileElement(Document document, Node sourceNode, Node displayNode, String workspaceName) throws Exception {
        Element file = document.createElement("File");
        file.setAttribute("name", displayNode.getName());
        file.setAttribute("workspaceName", workspaceName);
        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3);
        file.setAttribute("dateCreated", formatter.format(sourceNode.getProperty("exo:dateCreated").getDate().getTime()));
        if (sourceNode.hasProperty("exo:dateModified")) {
            file.setAttribute("dateModified", formatter.format(sourceNode.getProperty("exo:dateModified").getDate().getTime()));
        } else {
            file.setAttribute("dateModified", null);
        }
        file.setAttribute("creator", sourceNode.getProperty("exo:owner").getString());
        file.setAttribute("path", displayNode.getPath());
        if (sourceNode.isNodeType("nt:file")) {
            Node content = sourceNode.getNode("jcr:content");
            file.setAttribute("nodeType", content.getProperty("jcr:mimeType").getString());
        } else {
            file.setAttribute("nodeType", sourceNode.getPrimaryNodeType().getName());
        }
        long size = sourceNode.getNode("jcr:content").getProperty("jcr:data").getLength();
        file.setAttribute("size", "" + size);
        return file;
    }

    private Node getNode(String workspaceName, String nodePath) throws Exception {
        Node node;
        Session session = this.getSession(workspaceName);
        if (nodePath.trim().equals("/")) {
            node = session.getRootNode();
        } else {
            NodeFinder nodeFinder = this.getApplicationComponent(NodeFinder.class);
            if (nodePath.indexOf("${userId}") > -1) {
                String rootTreeOfSpecialDriver;
                String userId = Util.getPortalRequestContext().getRemoteUser();
                nodePath = rootTreeOfSpecialDriver = Utils.getPersonalDrivePath((String)nodePath, (String)userId);
            }
            node = (Node)nodeFinder.getItem(workspaceName, nodePath);
        }
        return node;
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        ManageableRepository manageableRepository = this.getCurrentRepository();
        return sessionProvider.getSession(workspaceName, manageableRepository);
    }

    private Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    private ManageableRepository getCurrentRepository() throws RepositoryException {
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    private <T> T getApplicationComponent(Class<T> type) {
        return type.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(type));
    }

    private Response getResponse(Document document) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(this.cc).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }
}

