/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

public final class UserContext {
    public static final Permission USER_CONTEXT_PERMISSION = new RuntimePermission("updateUserContext");
    private static ThreadLocal<UserContext> tlHolder = new ThreadLocal();
    private final String userId;
    private Map<String, String> properties;

    public static UserContext getCurrent() {
        return tlHolder.get();
    }

    public static void setCurrent(UserContext ctx) {
        UserContext.checkPermissions();
        tlHolder.set(ctx);
    }

    private static void checkPermissions() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(USER_CONTEXT_PERMISSION);
        }
    }

    public UserContext(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("User ID may not be null. ");
        }
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public void setProperty(String name, String value) {
        UserContext.checkPermissions();
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }
}

