/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.jndi;
import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class IndirectRecoverableConnection
implements RecoverableXAConnection,
ConnectionControl {
    private String _dbName;
    private String _user;
    private String _passwd;
    private XAConnection _theConnection;
    private XADataSource _theDataSource;
    private XAResource _theXAResource;
    private Transaction _theTransaction;
    private ConnectionImple _theArjunaConnection;
    private ConnectionModifier _theModifier;

    public IndirectRecoverableConnection() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(1L, 4L, 1L, "IndirectRecoverableConnection.IndirectRecoverableConnection ()");
        }
        this._dbName = null;
        this._user = null;
        this._passwd = null;
        this._theConnection = null;
        this._theDataSource = null;
        this._theXAResource = null;
        this._theTransaction = null;
        this._theArjunaConnection = null;
        this._theModifier = null;
    }

    public IndirectRecoverableConnection(String dbName, String user, String passwd, ConnectionImple conn) throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(1L, 4L, 1L, "IndirectRecoverableConnection.IndirectRecoverableConnection ( " + dbName + ", " + user + ", " + passwd + " )");
        }
        this._dbName = dbName;
        this._user = user;
        this._passwd = passwd;
        this._theConnection = null;
        this._theDataSource = null;
        this._theXAResource = null;
        this._theTransaction = null;
        this._theArjunaConnection = conn;
        jndi jndiModifier = new jndi();
        this._dbName = jndiModifier.initialise(this._dbName);
        this._theModifier = null;
        this.createDataSource();
    }

    public void finalize() {
        block3: {
            try {
                if (this._theConnection != null) {
                    this._theConnection.close();
                    this._theConnection = null;
                }
            }
            catch (SQLException e) {
                if (!jdbcLogger.loggerI18N.isWarnEnabled()) break block3;
                jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.drcdest", new Object[]{e});
            }
        }
    }

    public boolean packInto(OutputObjectState os) {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.packInto ()");
        }
        try {
            os.packString(this._dbName);
            os.packString(this._user);
            os.packString(this._passwd);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean unpackFrom(InputObjectState os) {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.unpackFrom ()");
        }
        try {
            this._dbName = os.unpackString();
            this._user = os.unpackString();
            this._passwd = os.unpackString();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    public XAResource getResource() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.getResource ()");
        }
        try {
            if (this._theXAResource == null) {
                this._theXAResource = this.getConnection().getXAResource();
            }
            return this._theXAResource;
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    public final void close() {
        this.reset();
    }

    public final void reset() {
        this._theXAResource = null;
        this._theTransaction = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTransaction(Transaction tx2) {
        IndirectRecoverableConnection indirectRecoverableConnection = this;
        synchronized (indirectRecoverableConnection) {
            if (this._theTransaction == null) {
                this._theTransaction = tx2;
                return true;
            }
        }
        return this.validTransaction(tx2);
    }

    public boolean validTransaction(Transaction tx2) {
        boolean valid = true;
        if (this._theTransaction != null) {
            valid = this._theTransaction.equals(tx2);
        }
        return valid;
    }

    public XAConnection getCurrentConnection() throws SQLException {
        return this._theConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCloseCurrentConnection() throws SQLException {
        IndirectRecoverableConnection indirectRecoverableConnection = this;
        synchronized (indirectRecoverableConnection) {
            if (this._theConnection != null) {
                this._theConnection.close();
                this._theConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getConnection() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.getConnection ()");
        }
        try {
            IndirectRecoverableConnection indirectRecoverableConnection = this;
            synchronized (indirectRecoverableConnection) {
                if (this._theConnection == null) {
                    this.createConnection();
                }
            }
            return this._theConnection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
    }

    public XADataSource getDataSource() throws SQLException {
        if (jdbcLogger.logger.isDebugEnabled()) {
            jdbcLogger.logger.debug(16L, 4L, 1L, "IndirectRecoverableConnection.getDataSource ()");
        }
        return this._theDataSource;
    }

    public boolean inuse() {
        return this._theXAResource != null;
    }

    public String user() {
        return this._user;
    }

    public String password() {
        return this._passwd;
    }

    public String url() {
        return this._dbName;
    }

    public String dynamicClass() {
        return "";
    }

    public String dataSourceName() {
        if (this._theDataSource != null) {
            return this._theDataSource.toString();
        }
        return "";
    }

    public Transaction transaction() {
        return this._theTransaction;
    }

    public void setModifier(ConnectionModifier cm) {
        this._theModifier = cm;
        if (this._theModifier != null) {
            this._dbName = this._theModifier.initialise(this._dbName);
        }
    }

    private final void createDataSource() throws SQLException {
        try {
            if (this._theDataSource == null) {
                Hashtable<String, String> env = new Hashtable<String, String>();
                Enumeration e = jdbcPropertyManager.propertyManager.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (!name.startsWith("Context.")) continue;
                    env.put(this.translate(name), jdbcPropertyManager.propertyManager.getProperty(name));
                }
                if (env.size() > 0) {
                    InitialContext ctx = new InitialContext(env);
                    this._theDataSource = (XADataSource)ctx.lookup(this._dbName);
                } else {
                    this._theDataSource = null;
                }
                if (this._theDataSource == null) {
                    throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.jndierror"));
                }
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
    }

    private final void createConnection() throws SQLException {
        try {
            if (this._theDataSource == null) {
                this.createDataSource();
            }
            this._theConnection = this._user == null && this._passwd == null ? this._theDataSource.getXAConnection() : this._theDataSource.getXAConnection(this._user, this._passwd);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.toString());
        }
    }

    private final String translate(String name) {
        try {
            if (name.equals("Context.APPLET")) {
                return "java.naming.applet";
            }
            if (name.equals("Context.AUTHORITATIVE")) {
                return "java.naming.authoritative";
            }
            if (name.equals("Context.BATCHSIZE")) {
                return "java.naming.batchsize";
            }
            if (name.equals("Context.DNS_URL")) {
                return "java.naming.dns.url";
            }
            if (name.equals("Context.INITIAL_CONTEXT_FACTORY")) {
                return "java.naming.factory.initial";
            }
            if (name.equals("Context.LANGUAGE")) {
                return "java.naming.language";
            }
            if (name.equals("Context.OBJECT_FACTORIES")) {
                return "java.naming.factory.object";
            }
            if (name.equals("Context.PROVIDER_URL")) {
                return "java.naming.provider.url";
            }
            if (name.equals("Context.REFERRAL")) {
                return "java.naming.referral";
            }
            if (name.equals("Context.SECURITY_AUTHENTICATION")) {
                return "java.naming.security.authentication";
            }
            if (name.equals("Context.SECURITY_CREDENTIALS")) {
                return "java.naming.security.credentials";
            }
            if (name.equals("Context.SECURITY_PRINCIPAL")) {
                return "java.naming.security.principal";
            }
            if (name.equals("Context.SECURITY_PROTOCOL")) {
                return "java.naming.security.protocol";
            }
            if (name.equals("Context.STATE_FACTORIES")) {
                return "java.naming.factory.state";
            }
            if (name.equals("Context.URL_PKG_PREFIXES")) {
                return "java.naming.factory.url.pkgs";
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return name;
    }
}

