/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.txoj;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionHierarchy;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.txoj.LockMode;
import com.arjuna.ats.txoj.LockStatus;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Lock
extends StateManager {
    private int currentStatus;
    private Lock nextLock;
    private int lMode;
    private ActionHierarchy owners;
    private static Uid applicUid = null;
    private static int applicPid = Utility.getpid();

    public Lock() {
        super(2);
        this.currentStatus = 0;
        this.nextLock = null;
        this.lMode = 1;
        this.owners = new ActionHierarchy(0);
    }

    public Lock(int lm) {
        super(2);
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 4L, 2L, "Lock::Lock(" + lm + ")");
        }
        this.currentStatus = 0;
        this.nextLock = null;
        this.lMode = lm;
        this.owners = new ActionHierarchy(0);
        BasicAction curr = BasicAction.Current();
        if (curr == null) {
            int currentPid = 0;
            ActionHierarchy ah = new ActionHierarchy(1);
            if (applicUid == null) {
                applicUid = new Uid();
            }
            if (applicPid != currentPid) {
                Uid temp = new Uid();
                applicPid = currentPid;
                applicUid.copy(temp);
            }
            ah.add(applicUid);
            this.owners.copy(ah);
        } else {
            this.owners.copy(curr.getHierarchy());
        }
    }

    public Lock(Uid storeUid) {
        super(storeUid, 2);
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 4L, 2L, "Lock::Lock(" + storeUid + ")");
        }
        this.currentStatus = 0;
        this.nextLock = null;
        this.lMode = 1;
        this.owners = new ActionHierarchy(0);
    }

    public void finalize() throws Throwable {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(2L, 4L, 2L, "Lock.finalize()");
        }
        super.terminate();
        this.owners = null;
        super.finalize();
    }

    public final int getLockMode() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getLockMode()");
        }
        return this.lMode;
    }

    public final Uid getCurrentOwner() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getCurrentOwner()");
        }
        return this.owners.getDeepestActionUid();
    }

    public final ActionHierarchy getAllOwners() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getAllOwners()");
        }
        return this.owners;
    }

    public final int getCurrentStatus() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getCurrentStatus()");
        }
        return this.currentStatus;
    }

    public final void changeHierarchy(ActionHierarchy newOwner) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getCurrentOwner()");
        }
        this.owners.copy(newOwner);
        if (this.currentStatus == 0) {
            this.currentStatus = 1;
        }
    }

    public final void propagate() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::propagate()");
        }
        this.owners.forgetDeepest();
        this.currentStatus = 2;
    }

    public boolean modifiesObject() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::modifiesObject()");
        }
        return this.lMode == 1;
    }

    public boolean conflictsWith(Lock otherLock) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 2L, "Lock::conflictsWith(" + otherLock + ")\n" + "\tLock 1:\n" + this + "\n" + "\tLock 2:\n" + otherLock);
        }
        if (!this.getCurrentOwner().equals(otherLock.getCurrentOwner())) {
            switch (this.lMode) {
                case 1: {
                    return true;
                }
                case 0: {
                    if (otherLock.getLockMode() == 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object otherLock) {
        if (otherLock instanceof Lock) {
            return this.equals((Lock)otherLock);
        }
        return false;
    }

    public boolean equals(Lock otherLock) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(32L, 4L, 2L, "Lock::equals(" + otherLock + ")\n" + "\tLock 1:\n" + this + "\n" + "\tLock 2:\n" + otherLock);
        }
        if (this == otherLock) {
            return true;
        }
        return this.lMode == otherLock.lMode && this.owners.equals(otherLock.owners) && this.currentStatus == otherLock.currentStatus;
    }

    public String toString() {
        StringWriter strm = new StringWriter();
        strm.write("Lock object : \n");
        strm.write("\tunique id is : " + this.get_uid() + "\n");
        strm.write("\tcurrent_status : " + LockStatus.printString(this.currentStatus));
        strm.write("\n\tMode : " + LockMode.stringForm(this.lMode));
        strm.write("\n\tOwner List : \n");
        this.owners.print(new PrintWriter(strm));
        return strm.toString();
    }

    public void print(PrintWriter strm) {
        strm.print(this.toString());
    }

    public boolean restore_state(InputObjectState os, int ot) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 2L, "Lock::restore_state(" + os + ", " + ot + ")");
        }
        ActionHierarchy ah = new ActionHierarchy(0);
        try {
            this.currentStatus = os.unpackInt();
            this.lMode = os.unpackInt();
            ah.unpack(os);
            this.owners = ah;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean save_state(OutputObjectState os, int ot) {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 2L, "Lock::save_state(" + os + ", " + ot + ")");
        }
        try {
            os.packInt(this.currentStatus);
            os.packInt(this.lMode);
            this.owners.pack(os);
            return os.valid();
        }
        catch (IOException e) {
            return false;
        }
    }

    public String type() {
        return "/StateManager/Lock";
    }

    protected Lock getLink() {
        return this.nextLock;
    }

    protected void setLink(Lock pointTo) {
        this.nextLock = pointTo;
    }
}

