/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class UNICAST
extends Protocol
implements AckSenderWindow.RetransmitCommand,
AgeOutCache.Handler<Address> {
    public static final long DEFAULT_FIRST_SEQNO = 1L;
    private boolean loopback = false;
    private long[] timeout = new long[]{400L, 800L, 1600L, 3200L};
    private long num_msgs_sent = 0L;
    private long num_msgs_received = 0L;
    private long num_bytes_sent = 0L;
    private long num_bytes_received = 0L;
    private long num_acks_sent = 0L;
    private long num_acks_received = 0L;
    private long num_xmits = 0L;
    private final Vector<Address> members = new Vector(11);
    private final ConcurrentMap<Address, SenderEntry> send_table = new ConcurrentHashMap<Address, SenderEntry>();
    private final ConcurrentMap<Address, ReceiverEntry> recv_table = new ConcurrentHashMap<Address, ReceiverEntry>();
    private Address local_addr = null;
    private TimeScheduler timer = null;
    private boolean started = false;
    private volatile boolean disconnected = false;
    private final AtomicInteger undelivered_msgs = new AtomicInteger(0);
    private long last_conn_id = 0L;
    protected long max_retransmit_time = 60000L;
    private AgeOutCache<Address> cache = null;

    public long[] getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long[] val) {
        if (val != null) {
            this.timeout = val;
        }
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "[]";
    }

    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.recv_table.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    public long getNumberOfRetransmissions() {
        return this.num_xmits;
    }

    public long getMaxRetransmitTime() {
        return this.max_retransmit_time;
    }

    public void setMaxRetransmitTime(long max_retransmit_time) {
        this.max_retransmit_time = max_retransmit_time;
        if (this.cache != null && max_retransmit_time > 0L) {
            this.cache.setTimeout(max_retransmit_time);
        }
    }

    public int getAgeOutCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    public String printAgeOutCache() {
        return this.cache != null ? this.cache.toString() : "n/a";
    }

    public AgeOutCache getAgeOutCache() {
        return this.cache;
    }

    public int getNumberOfUnackedMessages() {
        int num = 0;
        for (SenderEntry entry : this.send_table.values()) {
            if (entry.sent_msgs == null) continue;
            num += entry.sent_msgs.size();
        }
        return num;
    }

    public String printUnackedMessages() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.send_table.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            SenderEntry val = (SenderEntry)entry.getValue();
            if (val.sent_msgs == null) continue;
            sb.append(val.sent_msgs).append("\n");
        }
        return sb.toString();
    }

    public int getNumberOfMessagesInReceiveWindows() {
        int num = 0;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            num += entry.received_msgs.size();
        }
        return num;
    }

    @Override
    public void resetStats() {
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_xmits = 0L;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> m = super.dumpStats();
        m.put("unacked_msgs", this.printUnackedMessages());
        m.put("num_msgs_sent", this.num_msgs_sent);
        m.put("num_msgs_received", this.num_msgs_received);
        m.put("num_bytes_sent", this.num_bytes_sent);
        m.put("num_bytes_received", this.num_bytes_received);
        m.put("num_acks_sent", this.num_acks_sent);
        m.put("num_acks_received", this.num_acks_received);
        m.put("num_xmits", this.num_xmits);
        m.put("num_unacked_msgs", this.getNumberOfUnackedMessages());
        m.put("num_msgs_in_recv_windows", this.getNumberOfMessagesInReceiveWindows());
        return m;
    }

    @Override
    public String getName() {
        return "UNICAST";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            if (tmp != null && tmp.length > 0) {
                this.timeout = tmp;
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("window_size")) != null) {
            props.remove("window_size");
            this.log.warn((Object)"window_size is deprecated and will be ignored");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            props.remove("min_threshold");
            this.log.warn((Object)"min_threshold is deprecated and will be ignored");
        }
        if ((str = props.getProperty("use_gms")) != null) {
            this.log.warn((Object)"use_gms has been deprecated and is ignored");
            props.remove("use_gms");
        }
        if ((str = props.getProperty("immediate_ack")) != null) {
            this.log.warn((Object)"immediate_ack has been deprecated and is ignored");
            props.remove("immediate_ack");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if ((str = props.getProperty("eager_lock_release")) != null) {
            this.log.warn((Object)"eager_lock_release has been deprecated and is ignored");
            props.remove("eager_lock_release");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.max_retransmit_time > 0L) {
            this.cache = new AgeOutCache(this.timer, this.max_retransmit_time, this);
        }
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
        this.removeAllConnections();
        this.undelivered_msgs.set(0);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress() || (hdr = (UnicastHeader)msg.getHeader(this.getName())) == null) break;
                Address src = msg.getSrc();
                switch (hdr.type) {
                    case 0: {
                        this.handleDataReceived(src, hdr.seqno, hdr.conn_id, hdr.first, msg);
                        return null;
                    }
                    case 1: {
                        this.handleAckReceived(src, hdr.seqno);
                        break;
                    }
                    case 2: {
                        this.handleResendingOfFirstMessage(src);
                        break;
                    }
                    default: {
                        this.log.error((Object)("UnicastHeader type " + hdr.type + " not known !"));
                    }
                }
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress()) break;
                if (!this.started) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("discarded message as start() has not yet been called, message: " + msg));
                    }
                    return null;
                }
                if (this.loopback && this.local_addr != null && this.local_addr.equals(dst)) {
                    msg.setSrc(this.local_addr);
                    this.up_prot.up(evt);
                    ++this.num_msgs_sent;
                    this.num_bytes_sent += (long)msg.getLength();
                    return null;
                }
                SenderEntry entry = (SenderEntry)this.send_table.get(dst);
                if (entry == null) {
                    entry = new SenderEntry(this.getNewConnectionId(), this, this.timeout, this.timer, this.local_addr);
                    SenderEntry existing = this.send_table.putIfAbsent(dst, entry);
                    if (existing != null) {
                        entry = existing;
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(this.local_addr + ": created connection to " + dst));
                        }
                        if (this.cache != null && !this.members.contains(dst)) {
                            this.cache.add(dst);
                        }
                    }
                }
                long seqno = -2L;
                long send_conn_id = -1L;
                entry.lock();
                try {
                    seqno = entry.sent_msgs_seqno;
                    send_conn_id = entry.send_conn_id;
                    hdr = new UnicastHeader(0, seqno, send_conn_id, seqno == 1L);
                    msg.putHeader(this.getName(), hdr);
                    entry.sent_msgs.add(seqno, msg);
                    ++entry.sent_msgs_seqno;
                }
                finally {
                    entry.unlock();
                }
                if (this.log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.local_addr).append(" --> DATA(").append(dst).append(": #").append(seqno).append(", conn_id=").append(send_conn_id);
                    if (hdr.first) {
                        sb.append(", first");
                    }
                    sb.append(')');
                    this.log.trace((Object)sb);
                }
                try {
                    this.send(msg, evt);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"failed sending the message", t);
                }
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                Vector<Address> new_members = view.getMembers();
                HashSet non_members = new HashSet(this.send_table.keySet());
                non_members.addAll(this.recv_table.keySet());
                Vector<Address> vector = this.members;
                synchronized (vector) {
                    this.members.clear();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                    non_members.removeAll(this.members);
                    if (this.cache != null) {
                        this.cache.removeAll(this.members);
                    }
                }
                if (non_members.isEmpty()) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("removing non members " + non_members));
                }
                for (Address non_mbr : non_members) {
                    this.removeConnection(non_mbr);
                }
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 2: {
                this.disconnected = false;
                break;
            }
            case 4: {
                this.disconnected = true;
            }
        }
        return this.down_prot.down(evt);
    }

    private void send(Message msg, Event evt) {
        this.down_prot.down(evt);
        ++this.num_msgs_sent;
        this.num_bytes_sent += (long)msg.getLength();
    }

    public void removeConnection(Address mbr) {
        ReceiverEntry entry2;
        SenderEntry entry = (SenderEntry)this.send_table.remove(mbr);
        if (entry != null) {
            entry.reset();
        }
        if ((entry2 = (ReceiverEntry)this.recv_table.remove(mbr)) != null) {
            entry2.reset();
        }
    }

    protected void removeAllConnections() {
        for (SenderEntry entry : this.send_table.values()) {
            entry.reset();
        }
        this.send_table.clear();
        for (ReceiverEntry entry2 : this.recv_table.values()) {
            entry2.reset();
        }
        this.recv_table.clear();
    }

    @Override
    public void retransmit(long seqno, Message msg) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.local_addr + " --> XMIT(" + msg.getDest() + ": #" + seqno + ')'));
        }
        this.down_prot.down(new Event(1, msg));
        ++this.num_xmits;
    }

    @Override
    public void expired(Address key) {
        if (key != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("removing connection to " + key + " because it expired"));
            }
            this.removeConnection(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataReceived(Address sender, long seqno, long conn_id, boolean first, Message msg) {
        AtomicBoolean processing;
        AckReceiverWindow win;
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" <-- DATA(").append(sender).append(": #").append(seqno);
            if (conn_id != 0L) {
                sb.append(", conn_id=").append(conn_id);
            }
            if (first) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace((Object)sb);
        }
        Address send_request_for_first_seqno = null;
        ConcurrentMap<Address, ReceiverEntry> concurrentMap = this.recv_table;
        synchronized (concurrentMap) {
            ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
            AckReceiverWindow ackReceiverWindow = win = entry != null ? entry.received_msgs : null;
            if (first) {
                if (entry == null || win == null) {
                    win = this.createReceiverWindow(sender, entry, seqno, conn_id);
                } else if (conn_id != entry.recv_conn_id) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)(this.local_addr + ": conn_id=" + conn_id + " != " + entry.recv_conn_id + "; resetting receiver window"));
                    }
                    win = this.createReceiverWindow(sender, entry, seqno, conn_id);
                }
            } else if (win == null || entry.recv_conn_id != conn_id) {
                send_request_for_first_seqno = sender;
            }
        }
        if (send_request_for_first_seqno != null) {
            this.sendRequestForFirstSeqno(send_request_for_first_seqno);
            return;
        }
        byte result = win.add2(seqno, msg);
        boolean added = result > 0;
        ++this.num_msgs_received;
        this.num_bytes_received += (long)msg.getLength();
        if (added && !msg.isFlagSet((byte)1)) {
            this.undelivered_msgs.incrementAndGet();
        }
        if (result == -1) {
            this.sendAck(msg.getSrc(), seqno);
        }
        if (msg.isFlagSet((byte)1)) {
            if (added) {
                this.up_prot.up(new Event(1, msg));
            }
            Message oob_msg = win.removeOOBMessage();
            if (this.undelivered_msgs.get() <= 0 || !win.hasMessagesToRemove()) {
                if (oob_msg != null) {
                    this.sendAckForMessage(oob_msg);
                }
                return;
            }
        }
        if (!(processing = win.getProcessing()).compareAndSet(false, true)) {
            return;
        }
        boolean released_processing = false;
        int num_regular_msgs_removed = 0;
        try {
            block9: while (true) {
                List<Message> msgs;
                if ((msgs = win.removeMany(processing)).isEmpty()) {
                    released_processing = true;
                    return;
                }
                Message highest_removed = msgs.get(msgs.size() - 1);
                this.sendAckForMessage(highest_removed);
                Iterator<Message> i$ = msgs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block9;
                    Message m = i$.next();
                    if (m.isFlagSet((byte)1)) continue;
                    ++num_regular_msgs_removed;
                    try {
                        this.up_prot.up(new Event(1, m));
                    }
                    catch (Throwable t) {
                        this.log.error((Object)("couldn't deliver message " + m), t);
                    }
                }
                break;
            }
        }
        finally {
            this.undelivered_msgs.addAndGet(-num_regular_msgs_removed);
            if (!released_processing) {
                processing.set(false);
            }
        }
    }

    private AckReceiverWindow createReceiverWindow(Address sender, ReceiverEntry entry, long seqno, long conn_id) {
        if (entry == null) {
            entry = new ReceiverEntry();
            this.recv_table.put(sender, entry);
        }
        if (entry.received_msgs != null) {
            entry.received_msgs.reset();
        }
        entry.received_msgs = new AckReceiverWindow(seqno);
        entry.recv_conn_id = conn_id;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.local_addr + ": created receiver window for " + sender + " at seqno=#" + seqno + " for conn-id=" + conn_id));
        }
        return entry.received_msgs;
    }

    private void handleAckReceived(Address sender, long seqno) {
        SenderEntry entry;
        AckSenderWindow win;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuilder().append(this.local_addr).append(" <-- ACK(").append(sender).append(": #").append(seqno).append(')'));
        }
        AckSenderWindow ackSenderWindow = win = (entry = (SenderEntry)this.send_table.get(sender)) != null ? entry.sent_msgs : null;
        if (win != null) {
            win.ack(seqno);
            ++this.num_acks_received;
        }
    }

    private void handleResendingOfFirstMessage(Address sender) {
        SenderEntry entry;
        AckSenderWindow win;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.local_addr + " <-- SEND_FIRST_SEQNO(" + sender + ")"));
        }
        AckSenderWindow ackSenderWindow = win = (entry = (SenderEntry)this.send_table.get(sender)) != null ? entry.sent_msgs : null;
        if (win == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)(this.local_addr + ": sender window for " + sender + " not found"));
            }
            return;
        }
        Message rsp = win.getLowestMessage();
        if (rsp == null) {
            return;
        }
        Message copy = rsp.copy();
        UnicastHeader hdr = (UnicastHeader)copy.getHeader(this.getName());
        UnicastHeader newhdr = hdr.copy();
        newhdr.first = true;
        copy.putHeader(this.getName(), newhdr);
        this.down_prot.down(new Event(1, copy));
    }

    private void sendAck(Address dst, long seqno) {
        if (this.disconnected) {
            return;
        }
        Message ack = new Message(dst);
        ack.setFlag((byte)1);
        ack.putHeader(this.getName(), new UnicastHeader(1, seqno));
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuilder().append(this.local_addr).append(" --> ACK(").append(dst).append(": #").append(seqno).append(')'));
        }
        try {
            this.down_prot.down(new Event(1, ack));
            ++this.num_acks_sent;
        }
        catch (Throwable t) {
            this.log.error((Object)("failed sending ACK(" + seqno + ") to " + dst), t);
        }
    }

    private void sendAckForMessage(Message msg) {
        Address sender;
        UnicastHeader hdr = msg != null ? (UnicastHeader)msg.getHeader(this.getName()) : null;
        Address address = sender = msg != null ? msg.getSrc() : null;
        if (hdr != null && sender != null) {
            this.sendAck(sender, hdr.seqno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNewConnectionId() {
        long retval = System.currentTimeMillis();
        UNICAST uNICAST = this;
        synchronized (uNICAST) {
            if (this.last_conn_id == retval) {
                ++retval;
            }
            this.last_conn_id = retval;
            return retval;
        }
    }

    private void sendRequestForFirstSeqno(Address dest) {
        Message msg = new Message(dest);
        msg.setFlag((byte)1);
        UnicastHeader hdr = new UnicastHeader(2, 0L);
        msg.putHeader(this.getName(), hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.local_addr + " --> SEND_FIRST_SEQNO(" + dest + ")"));
        }
        this.down_prot.down(new Event(1, msg));
    }

    private static final class ReceiverEntry {
        AckReceiverWindow received_msgs = null;
        long recv_conn_id = 0L;

        private ReceiverEntry() {
        }

        void reset() {
            if (this.received_msgs != null) {
                this.received_msgs.reset();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.received_msgs != null) {
                sb.append("received_msgs=").append(this.received_msgs).append('\n');
            }
            sb.append("recv_conn_id=" + this.recv_conn_id + "\n");
            return sb.toString();
        }
    }

    private static final class SenderEntry {
        final AckSenderWindow sent_msgs;
        long sent_msgs_seqno = 1L;
        final long send_conn_id;
        final Lock lock = new ReentrantLock();

        public SenderEntry(long send_conn_id, AckSenderWindow.RetransmitCommand cmd, long[] timeout, TimeScheduler timer, Address local_addr) {
            this.send_conn_id = send_conn_id;
            this.sent_msgs = new AckSenderWindow(cmd, new StaticInterval(timeout), timer, local_addr);
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            this.sent_msgs_seqno = 1L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.sent_msgs != null) {
                sb.append("sent_msgs=").append(this.sent_msgs).append('\n');
            }
            sb.append("send_conn_id=" + this.send_conn_id + "\n");
            return sb.toString();
        }
    }

    public static class UnicastHeader
    extends Header
    implements Streamable {
        public static final byte DATA = 0;
        public static final byte ACK = 1;
        public static final byte SEND_FIRST_SEQNO = 2;
        byte type = 0;
        long seqno = 0L;
        long conn_id = 0L;
        boolean first = false;
        static final int serialized_size = 18;
        private static final long serialVersionUID = -8983745221189309298L;

        public UnicastHeader() {
        }

        public UnicastHeader(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        public UnicastHeader(byte type, long seqno, long conn_id) {
            this(type, seqno);
            this.conn_id = conn_id;
        }

        public UnicastHeader(byte type, long seqno, long conn_id, boolean first) {
            this(type, seqno, conn_id);
            this.first = first;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[UNICAST: ").append(UnicastHeader.type2Str(this.type)).append(", seqno=").append(this.seqno);
            if (this.conn_id != 0L) {
                sb.append(", conn_id=").append(this.conn_id);
            }
            if (this.first) {
                sb.append(", first");
            }
            sb.append(']');
            return sb.toString();
        }

        public static String type2Str(byte t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "ACK";
                }
                case 2: {
                    return "SEND_FIRST_SEQNO";
                }
            }
            return "<unknown>";
        }

        @Override
        public final int size() {
            return 18;
        }

        public UnicastHeader copy() {
            return new UnicastHeader(this.type, this.seqno, this.conn_id, this.first);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
            out.writeLong(this.conn_id);
            out.writeBoolean(this.first);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.seqno = in.readLong();
            this.conn_id = in.readLong();
            this.first = in.readBoolean();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
            out.writeLong(this.conn_id);
            out.writeBoolean(this.first);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.seqno = in.readLong();
            this.conn_id = in.readLong();
            this.first = in.readBoolean();
        }
    }
}

