/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.blocks.RpcDispatcher;

public class NAKACKTest2 {
    Channel ch;
    Address local_addr;
    Receiver receiver;
    RpcDispatcher disp;

    public void receive(Address sender, Long i) {
        System.out.println(sender + "::" + i);
    }

    void start(String props, boolean use_rpc) throws Exception {
        long i = 0L;
        this.ch = new JChannel(props);
        if (use_rpc) {
            this.disp = new RpcDispatcher(this.ch, null, null, this);
        }
        this.ch.connect("NAKACKTest");
        this.local_addr = this.ch.getLocalAddress();
        if (!use_rpc) {
            this.receiver = new Receiver();
            this.receiver.start();
        }
        while (true) {
            if (use_rpc) {
                this.disp.callRemoteMethods(null, "receive", new Object[]{this.local_addr, new Long(i++)}, new Class[]{Address.class, Long.class}, 2, 10000L);
                continue;
            }
            Message msg = new Message(null, null, new Long(i++));
            this.ch.send(msg);
        }
    }

    public static void main(String[] args) {
        String props = null;
        boolean use_rpc = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-use_rpc".equals(args[i])) {
                use_rpc = true;
                continue;
            }
            NAKACKTest2.help();
            return;
        }
        try {
            new NAKACKTest2().start(props, use_rpc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("NAKACKTest [-help] [-props properties] [-use_rpc]");
    }

    class Receiver
    extends Thread {
        Receiver() {
        }

        @Override
        public void run() {
            boolean running = true;
            while (running) {
                try {
                    Object obj = NAKACKTest2.this.ch.receive(0L);
                    if (obj instanceof Message) {
                        Message msg = (Message)obj;
                        System.out.println(msg.getSrc() + "::" + msg.getObject());
                        continue;
                    }
                    System.out.println("received " + obj);
                }
                catch (ChannelNotConnectedException e) {
                    running = false;
                }
                catch (ChannelClosedException e) {
                    running = false;
                }
                catch (TimeoutException e) {}
            }
        }
    }
}

