/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.provider.EntityProvider;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class HierarchicalPropertyEntityProvider
implements EntityProvider<HierarchicalProperty> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.ext.HierarchicalPropertyEntityProvider");

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == HierarchicalProperty.class;
    }

    public HierarchicalProperty readFrom(Class<HierarchicalProperty> t, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        HierarchicalProperty rootProperty = null;
        LinkedList<HierarchicalProperty> curProperty = new LinkedList<HierarchicalProperty>();
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(entityStream);
            XMLEventReader fReader = factory.createFilteredReader(reader, new EventFilter(){

                public boolean accept(XMLEvent event) {
                    return !event.isCharacters() || !((Characters)event).isWhiteSpace();
                }
            });
            while (fReader.hasNext()) {
                XMLEvent event = fReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        StartElement element = event.asStartElement();
                        QName name = element.getName();
                        HierarchicalProperty prop = new HierarchicalProperty(name);
                        if (!curProperty.isEmpty()) {
                            ((HierarchicalProperty)curProperty.getLast()).addChild(prop);
                        } else {
                            rootProperty = prop;
                        }
                        curProperty.addLast(prop);
                        break;
                    }
                    case 2: {
                        curProperty.removeLast();
                        break;
                    }
                    case 4: {
                        String chars = event.asCharacters().getData();
                        ((HierarchicalProperty)curProperty.getLast()).setValue(chars);
                        break;
                    }
                }
            }
            return rootProperty;
        }
        catch (FactoryConfigurationError e) {
            throw new IOException(e.getMessage());
        }
        catch (XMLStreamException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"An XMLStreamException occurs", (Throwable)e);
            }
            return null;
        }
        catch (RuntimeException re) {
            String reName = re.getClass().getName();
            if (reName.equals("com.ctc.wstx.exc.WstxLazyException")) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)re.getMessage(), (Throwable)re);
                }
                return null;
            }
            throw re;
        }
    }

    public long getSize(HierarchicalProperty t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return HierarchicalProperty.class.isAssignableFrom(type);
    }

    public void writeTo(HierarchicalProperty t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Document e = (Document)t;
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(e), new StreamResult(entityStream));
        }
        catch (TransformerException tre) {
            throw new IOException("Can't write to output stream " + tre);
        }
    }
}

