/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public final class ThumbnailUtils {
    static Node getThumbnailFolder(Node parentNode) throws RepositoryException {
        if (!parentNode.hasNode("exo:thumbnails")) {
            try {
                Node thumbnailFolder = parentNode.addNode("exo:thumbnails", "exo:thumbnails");
                parentNode.getSession().save();
                if (thumbnailFolder.canAddMixin("exo:hiddenable")) {
                    thumbnailFolder.addMixin("exo:hiddenable");
                }
                parentNode.getSession().save();
                return thumbnailFolder;
            }
            catch (ItemExistsException itemExistsException) {
                // empty catch block
            }
        }
        return parentNode.getNode("exo:thumbnails");
    }

    static Node getThumbnailNode(Node thumbnailFolder, String identifier) throws RepositoryException {
        if (!thumbnailFolder.hasNode(identifier)) {
            try {
                Node thumbnailNode = thumbnailFolder.addNode(identifier, "exo:thumbnail");
                thumbnailFolder.getSession().save();
                return thumbnailNode;
            }
            catch (ItemExistsException itemExistsException) {
                // empty catch block
            }
        }
        return thumbnailFolder.getNode(identifier);
    }
}

