/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.transaction.impl.jotm;

import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.transaction.impl.AbstractTransactionService;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionFactoryImpl;

public class TransactionServiceJotmImpl
extends AbstractTransactionService {
    protected static Log log = ExoLogger.getLogger((String)"exo.kernel.component.common.TransactionServiceJotmImpl");
    private final int defaultTimeout;

    public TransactionServiceJotmImpl(InitialContextInitializer initializer, InitParams params) {
        this.defaultTimeout = params != null && params.getValueParam("timeout") != null ? Integer.parseInt(params.getValueParam("timeout").getValue()) : -1;
    }

    public TransactionManager findTransactionManager() throws Exception {
        Current current = Current.getCurrent();
        if (current == null) {
            try {
                current = (Current)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Current>(){

                    @Override
                    public Current run() throws Exception {
                        TransactionFactoryImpl tm = new TransactionFactoryImpl();
                        return new Current((TransactionFactory)tm);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof RemoteException) {
                    throw (RemoteException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            if (this.defaultTimeout > 0) {
                current.setDefaultTimeout(this.defaultTimeout);
            }
        } else {
            log.info((Object)("Use externally initialized JOTM: " + current));
        }
        return current;
    }

    public UserTransaction findUserTransaction() {
        return (UserTransaction)this.getTransactionManager();
    }

    public int getDefaultTimeout() {
        return ((Current)this.getTransactionManager()).getDefaultTimeout();
    }
}

