/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.attr;

import java.beans.PropertyEditor;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.attr.AbstractWebAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieAttribute<T>
extends AbstractWebAttribute<T> {
    private static final Log log = LogFactory.getLog(CookieAttribute.class);
    public static final int ONE_YEAR = 31536000;
    public static final int INDEFINITE = Integer.MAX_VALUE;
    public static final String DEFAULT_PATH = null;
    public static final int DEFAULT_MAX_AGE = -1;
    public static final boolean DEFAULT_SECURE = false;
    private String path = DEFAULT_PATH;
    private int maxAge = -1;
    private boolean secure = false;

    public CookieAttribute() {
    }

    public CookieAttribute(String name) {
        super(name);
    }

    public CookieAttribute(String name, String path) {
        super(name);
        this.setPath(path);
    }

    public CookieAttribute(String name, int maxAge) {
        super(name);
        this.setMaxAge(maxAge);
    }

    public CookieAttribute(String name, String path, int maxAge) {
        this(name, path);
        this.setMaxAge(maxAge);
    }

    public CookieAttribute(String name, String path, int maxAge, Class<? extends PropertyEditor> editorClass) {
        super(name, editorClass);
        this.setPath(path);
        this.setMaxAge(maxAge);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    private static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    @Override
    public T onRetrieveValue(ServletRequest request, ServletResponse response) {
        T value = null;
        Cookie cookie = CookieAttribute.getCookie(WebUtils.toHttp(request), this.getName());
        if (cookie != null && cookie.getMaxAge() != 0) {
            String stringValue = cookie.getValue();
            if (log.isInfoEnabled()) {
                log.info((Object)("Found string value [" + stringValue + "] from HttpServletRequest Cookie [" + this.getName() + "]"));
            }
            value = this.fromStringValue(stringValue);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No value found in request Cookies under cookie name [" + this.getName() + "]"));
        }
        return value;
    }

    @Override
    public void onStoreValue(T value, ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletRequest request = WebUtils.toHttp(servletRequest);
        HttpServletResponse response = WebUtils.toHttp(servletResponse);
        String name = this.getName();
        int maxAge = this.getMaxAge();
        String path = this.getPath() != null ? this.getPath() : request.getContextPath();
        String stringValue = this.toStringValue(value);
        Cookie cookie = new Cookie(name, stringValue);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        if (this.isSecure()) {
            cookie.setSecure(true);
        }
        response.addCookie(cookie);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Added Cookie [" + name + "] to path [" + path + "] with value [" + stringValue + "] to the HttpServletResponse."));
        }
    }

    @Override
    public void removeValue(ServletRequest servletRequest, ServletResponse response) {
        HttpServletRequest request = WebUtils.toHttp(servletRequest);
        Cookie cookie = CookieAttribute.getCookie(request, this.getName());
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setPath(this.getPath() == null ? request.getContextPath() : this.getPath());
            cookie.setSecure(this.isSecure());
            WebUtils.toHttp(response).addCookie(cookie);
        }
    }
}

