/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.extensions.component.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.extensions.security.SHAMessageDigester;

@Path(value="/copyfile/")
public class CopyContentFile
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger(CopyContentFile.class);
    private static final String OK_RESPONSE = "OK";
    private static final String KO_RESPONSE = "KO";
    private static String stagingStorage;
    private static String targetKey;
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    public CopyContentFile(InitParams params) {
        stagingStorage = params.getValueParam("stagingStorage").getValue();
        targetKey = params.getValueParam("targetKey").getValue();
    }

    @POST
    @Path(value="/copy/")
    public Response copyFile(String param) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start Execute CopyContentFile Web Service");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        try {
            long time;
            String[] tabParam = param.split("&&");
            String timesTamp = tabParam[0].split("=")[1];
            String clientHash = tabParam[1].split("=")[1];
            String contents = tabParam[2].split("contentsfile=")[1];
            String[] tab = targetKey.split("$TIMESTAMP");
            StringBuffer resultKey = new StringBuffer();
            for (int k = 0; k < tab.length; ++k) {
                resultKey.append(tab[k]);
                if (k == tab.length - 1) continue;
                resultKey.append(timesTamp);
            }
            String serverHash = SHAMessageDigester.getHash(resultKey.toString());
            if (serverHash != null && serverHash.equals(clientHash)) {
                Date date = new Date();
                time = date.getTime();
                File stagingFolder = new File(stagingStorage);
                if (!stagingFolder.exists()) {
                    stagingFolder.mkdirs();
                }
            } else {
                log.warn((Object)"Anthentification failed...");
                return Response.ok((Object)"KO...Anthentification failed", (String)"text/plain").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
            File contentsFile = new File(stagingStorage + File.separator + clientHash + "-" + time + ".xml");
            FileOutputStream ops = new FileOutputStream(contentsFile);
            ((OutputStream)ops).write(contents.getBytes());
            ((OutputStream)ops).close();
        }
        catch (Exception ex) {
            log.error((Object)("error when copying content file" + ex.getMessage()));
            return Response.ok((Object)("KO..." + ex.getMessage()), (String)"text/plain").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start Execute CopyContentFile Web Service");
        }
        return Response.ok((Object)"OK...content has been successfully copied in the production server", (String)"text/plain").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }
}

