/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.resolver;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.exoplatform.resolver.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathResourceResolver
extends ResourceResolver {
    @Override
    public URL getResource(String url) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.getResource(this.removeScheme(url));
    }

    @Override
    public InputStream getInputStream(String url) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.getResourceAsStream(this.removeScheme(url));
    }

    @Override
    public List<URL> getResources(String url) throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> e = cl.getResources(this.removeScheme(url));
        while (e.hasMoreElements()) {
            urlList.add(e.nextElement());
        }
        return urlList;
    }

    @Override
    public List<InputStream> getInputStreams(String url) throws Exception {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> e = cl.getResources(this.removeScheme(url));
        while (e.hasMoreElements()) {
            inputStreams.add(e.nextElement().openStream());
        }
        return inputStreams;
    }

    @Override
    public boolean isModified(String url, long lastAccess) {
        return false;
    }

    @Override
    public String getResourceScheme() {
        return "classpath:";
    }
}

