/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.ext.script.groovy.ScriptKey;
import org.exoplatform.services.jcr.ext.script.groovy.SimpleScriptKey;
import org.exoplatform.services.jcr.ext.script.groovy.URLScriptKey;
import org.exoplatform.services.rest.ext.groovy.GroovyJaxrsPublisher;
import org.exoplatform.services.rest.ext.groovy.ResourceId;
import org.exoplatform.services.rest.impl.ResourcePublicationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseGroovyScriptManager {
    protected GroovyJaxrsPublisher groovyPublisher;

    public BaseGroovyScriptManager(GroovyJaxrsPublisher groovyPublisher) {
        this.groovyPublisher = groovyPublisher;
    }

    public boolean isLoaded(ScriptKey key) {
        return this.groovyPublisher.isPublished((ResourceId)key);
    }

    public boolean isLoaded(String key) {
        return this.isLoaded(new SimpleScriptKey(key));
    }

    public boolean isLoaded(URL url) {
        return this.isLoaded(new URLScriptKey(url));
    }

    public Response load(String repository, String workspace, String path, boolean state) {
        return this.load(repository, workspace, path, state, null);
    }

    public abstract Response load(String var1, String var2, String var3, boolean var4, List<String> var5, List<String> var6, MultivaluedMap<String, String> var7);

    public Response load(String repository, String workspace, String path, boolean state, MultivaluedMap<String, String> properties) {
        return this.load(repository, workspace, path, state, null, null, properties);
    }

    public boolean loadScript(ScriptKey key, String name, InputStream stream) throws IOException {
        try {
            this.groovyPublisher.publishPerRequest(stream, (ResourceId)key, null);
            return true;
        }
        catch (ResourcePublicationException e) {
            return false;
        }
    }

    public boolean loadScript(String key, InputStream stream) throws IOException {
        return this.loadScript(key, null, stream);
    }

    public boolean loadScript(String key, String name, InputStream stream) throws IOException {
        return this.loadScript(new SimpleScriptKey(key), name, stream);
    }

    public boolean loadScript(URL url) throws IOException {
        URLScriptKey key = new URLScriptKey(url);
        try {
            this.groovyPublisher.publishPerRequest((InputStream)new BufferedInputStream(url.openStream()), (ResourceId)key, null);
            return true;
        }
        catch (ResourcePublicationException e) {
            return true;
        }
    }

    public boolean unloadScript(ScriptKey key) {
        return null != this.groovyPublisher.unpublishResource((ResourceId)key);
    }

    public boolean unloadScript(String key) {
        return this.unloadScript(new SimpleScriptKey(key));
    }

    public void unloadScript(URL url) {
        this.unloadScript(new URLScriptKey(url));
    }

    public Response validateScript(String name, InputStream script) {
        return this.validateScript(name, script, null, null);
    }

    public abstract Response validateScript(String var1, InputStream var2, List<String> var3, List<String> var4);
}

