/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.imageio.ImageIO;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.ImageUtils;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.cms.thumbnail.impl.ThumbnailUtils;
import org.exoplatform.services.jcr.impl.core.NodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailServiceImpl
implements ThumbnailService {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_MIMETYPE = "jcr:mimeType";
    private static final String JCR_DATA = "jcr:data";
    private static final String NT_FILE = "nt:file";
    private boolean isEnableThumbnail_ = false;
    private String smallSize_;
    private String mediumSize_;
    private String bigSize_;
    private String mimeTypes_;
    private List<ComponentPlugin> plugins_ = new ArrayList<ComponentPlugin>();

    public ThumbnailServiceImpl(InitParams initParams) throws Exception {
        this.smallSize_ = initParams.getValueParam("smallSize").getValue();
        this.mediumSize_ = initParams.getValueParam("mediumSize").getValue();
        this.bigSize_ = initParams.getValueParam("bigSize").getValue();
        this.mimeTypes_ = initParams.getValueParam("mimetypes").getValue();
        this.isEnableThumbnail_ = Boolean.parseBoolean(initParams.getValueParam("enable").getValue());
    }

    @Override
    public List<Node> getFlowImages(Node node) throws Exception {
        NodeIterator nodeIter = node.getNodes();
        ArrayList<Node> listNodes = new ArrayList<Node>();
        Node thumbnailNode = null;
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            thumbnailNode = this.addThumbnailNode(childNode);
            if (thumbnailNode == null || !thumbnailNode.getPrimaryNodeType().getName().equals("exo:thumbnail") || !thumbnailNode.hasProperty("exo:bigSize")) continue;
            listNodes.add(childNode);
        }
        return listNodes;
    }

    @Override
    public List<Node> getAllFileInNode(Node node) throws RepositoryException {
        ArrayList<Node> fileListNodes = new ArrayList<Node>();
        NodeIterator nodeIter = node.getNodes();
        Node childNode = null;
        while (nodeIter.hasNext()) {
            childNode = nodeIter.nextNode();
            if (!childNode.getPrimaryNodeType().getName().equals(NT_FILE)) continue;
            fileListNodes.add(childNode);
        }
        return fileListNodes;
    }

    @Override
    public List<Node> getFileNodesByType(Node node, String jcrMimeType) throws RepositoryException {
        List<Node> fileListNodes = this.getAllFileInNode(node);
        ArrayList<Node> listNodes = new ArrayList<Node>();
        Node contentNode = null;
        for (Node childNode : fileListNodes) {
            contentNode = childNode.getNode(JCR_CONTENT);
            if (!contentNode.getProperty(JCR_MIMETYPE).getString().equals(jcrMimeType)) continue;
            listNodes.add(childNode);
        }
        return listNodes;
    }

    @Override
    public boolean isEnableThumbnail() {
        return this.isEnableThumbnail_;
    }

    @Override
    public void setEnableThumbnail(boolean isEnable) {
        this.isEnableThumbnail_ = isEnable;
    }

    @Override
    public InputStream getThumbnailImage(Node node, String thumbnailType) throws Exception {
        Node thumbnailNode = this.addThumbnailNode(node);
        if (thumbnailNode != null && thumbnailNode.hasProperty(thumbnailType)) {
            return thumbnailNode.getProperty(thumbnailType).getStream();
        }
        return null;
    }

    @Override
    public void addThumbnailImage(Node thumbnailNode, BufferedImage image, String propertyName) throws Exception {
        if (propertyName.equals("exo:smallSize")) {
            this.parseImageSize(thumbnailNode, image, this.smallSize_, "exo:smallSize");
        } else if (propertyName.equals("exo:mediumSize")) {
            this.parseImageSize(thumbnailNode, image, this.mediumSize_, "exo:mediumSize");
        } else if (propertyName.equals("exo:bigSize")) {
            this.parseImageSize(thumbnailNode, image, this.bigSize_, "exo:bigSize");
        } else {
            this.parseImageSize(thumbnailNode, image, propertyName.substring(4), propertyName, true);
        }
    }

    @Override
    public void createSpecifiedThumbnail(Node node, BufferedImage image, String propertyName) throws Exception {
        this.addThumbnailImage(this.addThumbnailNode(node), image, propertyName);
    }

    @Override
    public void createThumbnailImage(Node node, BufferedImage image, String mimeType) throws Exception {
        Node thumbnailNode = this.addThumbnailNode(node);
        if (thumbnailNode != null) {
            if (mimeType.startsWith("image")) {
                this.processImage2Image(thumbnailNode, image);
            }
            thumbnailNode.setProperty("exo:thumbnailLastModified", (Calendar)new GregorianCalendar());
            thumbnailNode.getSession().save();
        }
    }

    @Override
    public void processThumbnailList(List<Node> listNodes, String type) throws Exception {
        for (Node node : listNodes) {
            Node contentNode;
            Node thumbnailNode = this.addThumbnailNode(node);
            if (thumbnailNode == null || thumbnailNode.hasProperty("exo:thumbnailLastModified") || !node.isNodeType(NT_FILE) || !(contentNode = node.getNode(JCR_CONTENT)).getProperty(JCR_MIMETYPE).getString().startsWith("image")) continue;
            BufferedImage image = ImageIO.read(contentNode.getProperty(JCR_DATA).getStream());
            this.addThumbnailImage(thumbnailNode, image, type);
        }
    }

    @Override
    public List<String> getMimeTypes() {
        return Arrays.asList(this.mimeTypes_.split(";"));
    }

    @Override
    public Node addThumbnailNode(Node node) throws Exception {
        Node parentNode = node.getParent();
        Node thumbnailFolder = ThumbnailUtils.getThumbnailFolder(parentNode);
        String identifier = ((NodeImpl)node).getInternalIdentifier();
        Node thumbnailNode = ThumbnailUtils.getThumbnailNode(thumbnailFolder, identifier);
        return thumbnailNode;
    }

    @Override
    public Node getThumbnailNode(Node node) throws Exception {
        Node parentNode = node.getParent();
        try {
            Node thumbnailFolder = parentNode.getNode("exo:thumbnails");
            return thumbnailFolder.getNode(((NodeImpl)node).getInternalIdentifier());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void processRemoveThumbnail(Node showingNode) throws Exception {
        Node parentNode = showingNode.getParent();
        if (parentNode.hasNode("exo:thumbnails")) {
            Node thumbnailFolder = parentNode.getNode("exo:thumbnails");
            try {
                thumbnailFolder.getNode(((NodeImpl)showingNode).getInternalIdentifier()).remove();
                thumbnailFolder.getSession().save();
            }
            catch (PathNotFoundException path) {
                return;
            }
        }
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof ThumbnailPlugin) {
            this.plugins_.add(plugin);
        }
    }

    @Override
    public List<ComponentPlugin> getComponentPlugins() {
        return this.plugins_;
    }

    private void processImage2Image(Node node, BufferedImage image) throws Exception {
        this.parseImageSize(node, image, this.smallSize_, "exo:smallSize");
        this.parseImageSize(node, image, this.mediumSize_, "exo:mediumSize");
        this.parseImageSize(node, image, this.bigSize_, "exo:bigSize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createThumbnailImage(Node thumbnailNode, BufferedImage image, int width, int height, String propertyName, boolean crop) throws Exception {
        if (width > 1600) {
            width = 1600;
        }
        if (height > 1600) {
            height = 1600;
        }
        InputStream thumbnailStream = ImageUtils.scaleImage(image, width, height, crop);
        try {
            thumbnailNode.setProperty(propertyName, thumbnailStream);
            thumbnailNode.getSession().save();
            thumbnailNode.setProperty("exo:thumbnailLastModified", (Calendar)new GregorianCalendar());
            thumbnailNode.getSession().save();
        }
        catch (ItemExistsException e) {
        }
        finally {
            thumbnailStream.close();
        }
    }

    private void parseImageSize(Node node, BufferedImage image, String size, String propertyName) throws Exception {
        this.parseImageSize(node, image, size, propertyName, false);
    }

    private void parseImageSize(Node node, BufferedImage image, String size, String propertyName, boolean crop) throws Exception {
        int width = 0;
        int height = 0;
        if (size.startsWith("x")) {
            height = Integer.parseInt(size.substring(1));
        } else if (size.endsWith("x")) {
            width = Integer.parseInt(size.substring(0, size.length() - 1));
        } else if (size.indexOf("x") > -1) {
            String[] imageSize = size.split("x");
            width = Integer.parseInt(imageSize[0]);
            height = Integer.parseInt(imageSize[1]);
        }
        this.createThumbnailImage(node, image, width, height, propertyName, crop);
    }
}

