/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.presentation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.presentation.NodePresentation;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.voting.VotingService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIBaseNodePresentation
extends UIContainer
implements NodePresentation {
    private String language_;
    private boolean enableVote;
    private boolean enableComment;
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIBaseNodePresentation");

    @Override
    public abstract Node getNode() throws Exception;

    @Override
    public abstract String getTemplatePath() throws Exception;

    @Override
    public abstract Node getOriginalNode() throws Exception;

    public abstract String getRepositoryName() throws Exception;

    @Override
    public String encodeHTML(String text) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.encodeHTML(text);
    }

    @Override
    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        NodeIterator childrenIterator = this.getNode().getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List<String> listCanCreateNodeType = org.exoplatform.ecm.webui.utils.Utils.getListAllowedFileType(this.getNode(), templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            attachments.add(childNode);
        }
        return attachments;
    }

    @Override
    @Deprecated
    public String getAttachmentURL(Node attNode, Parameter[] params) throws Exception {
        return this.getViewableLink(attNode, params);
    }

    @Override
    public String getViewableLink(Node attNode, Parameter[] params) throws Exception {
        return "";
    }

    @Override
    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.getNode(), this.getLanguage());
    }

    @Override
    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> object = loader.loadClass(className);
            service = this.getApplicationComponent(object);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unexpected error", (Throwable)ex);
        }
        return service;
    }

    @Override
    public String getDownloadLink(Node node) throws Exception {
        return Utils.getDownloadLink(node);
    }

    @Override
    public String getIcons(Node node, String size) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon(node, size);
    }

    @Override
    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    @Override
    public String getLanguage() {
        return this.language_;
    }

    @Override
    public void setLanguage(String language) {
        this.language_ = language;
    }

    @Override
    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    @Override
    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.getNode().hasProperty("exo:relation")) {
            Value[] vals = this.getNode().getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    @Override
    public String getRepository() throws Exception {
        return ((ManageableRepository)this.getNode().getSession().getRepository()).getConfiguration().getName();
    }

    @Override
    public String getRssLink() {
        return null;
    }

    @Override
    public boolean isRssLink() {
        return false;
    }

    @Override
    public List getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.getNode());
    }

    @Override
    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    @Override
    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    @Override
    public String getWorkspaceName() throws Exception {
        return this.getNode().getSession().getWorkspace().getName();
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        String[] workspaces = manageRepo.getWorkspaceNames();
        SessionProvider provider = WCMCoreUtils.getSystemSessionProvider();
        for (String ws : workspaces) {
            try {
                return provider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public List<Node> getCategories(Node node) throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        return taxonomyService.getCategories(node, this.getRepositoryName());
    }

    public List<Node> getTags(Node node) throws Exception {
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        return folksonomyService.getLinkedTagsOfDocumentByScope(1, this.getStrValue("Private", node), node, this.getWorkspaceName());
    }

    public long getVotingRate(Node node) throws Exception {
        VotingService votingService = (VotingService)this.getApplicationComponent(VotingService.class);
        return votingService.getVoteTotal(node);
    }

    public String getImageURIInProperty(Node node, String propertyName) throws Exception {
        try {
            InputStream input = node.getProperty(propertyName).getStream();
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
            dresource.setDownloadName(node.getName());
            DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPortletPreferenceValue(String preferenceName) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (requestContext instanceof PortletRequestContext) {
            PortletRequestContext context = (PortletRequestContext)PortletRequestContext.class.cast(requestContext);
            return context.getRequest().getPreferences().getValue(preferenceName, null);
        }
        return null;
    }

    public String[] getPortletPreferenceValues(String preferenceName) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (requestContext instanceof PortletRequestContext) {
            PortletRequestContext context = (PortletRequestContext)PortletRequestContext.class.cast(requestContext);
            return context.getRequest().getPreferences().getValues(preferenceName, null);
        }
        return null;
    }

    @Override
    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage());
    }

    private String getStrValue(String scope, Node node) throws Exception {
        StringBuilder ret = new StringBuilder();
        if ("Private".equals(scope)) {
            ret.append(node.getSession().getUserID());
        } else if ("Group".equals(scope)) {
            for (String group : org.exoplatform.ecm.webui.utils.Utils.getGroups()) {
                ret.append(group).append(';');
            }
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    @Override
    public boolean isEnableComment() {
        return this.enableComment;
    }

    @Override
    public boolean isEnableVote() {
        return this.enableVote;
    }

    @Override
    public void setEnableComment(boolean value) {
        this.enableComment = value;
    }

    @Override
    public void setEnableVote(boolean value) {
        this.enableVote = value;
    }

    @Override
    public String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField(orgNode, propertyName, defaultValue, inputType, idGenerator, cssClass, isGenericProperty, arguments);
    }

    @Override
    public String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField(orgNode, propertyName);
    }
}

