/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeNodePageIterator;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.NodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.cms.timeline.TimelineService;
import org.exoplatform.services.cms.voting.VotingService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.ext.UIExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={ViewNodeActionListener.class}), @EventConfig(listeners={SortActionListener.class}), @EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={StarClickActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}), @EventConfig(listeners={SortTimelineASCActionListener.class}), @EventConfig(listeners={SortTimelineDESCActionListener.class})})
public class UIDocumentInfo
extends UIContainer
implements NodePresentation {
    private static final String CONTENT_PAGE_ITERATOR_ID = "ContentPageIterator";
    private static final String COMMENT_COMPONENT = "Comment";
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.search.UIDocumentInfo");
    private String typeSort_ = "Type";
    private String sortOrder_ = "BlueDownArrow";
    private NodeLocation currentNode_;
    private UIPageIterator pageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "ContentPageIterator");
    private List<NodeLocation> todayNodes;
    private List<NodeLocation> yesterdayNodes;
    private List<NodeLocation> earlierThisWeekNodes;
    private List<NodeLocation> earlierThisMonthNodes;
    private List<NodeLocation> earlierThisYearNodes;
    private String timeLineSortByFavourite = "BlueDownArrow";
    private String timeLineSortByName = "";
    private String timeLineSortByDate = "";
    private FavoriteService favoriteService = (FavoriteService)this.getApplicationComponent(FavoriteService.class);
    private DocumentTypeService documentTypeService = (DocumentTypeService)this.getApplicationComponent(DocumentTypeService.class);
    private TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);

    public String getTimeLineSortByFavourite() {
        return this.timeLineSortByFavourite;
    }

    public void setTimeLineSortByFavourite(String timeLineSortByFavourite) {
        this.timeLineSortByFavourite = timeLineSortByFavourite;
    }

    public String getTimeLineSortByName() {
        return this.timeLineSortByName;
    }

    public void setTimeLineSortByName(String timeLineSortByName) {
        this.timeLineSortByName = timeLineSortByName;
    }

    public String getTimeLineSortByDate() {
        return this.timeLineSortByDate;
    }

    public void setTimeLineSortByDate(String timeLineSortByDate) {
        this.timeLineSortByDate = timeLineSortByDate;
    }

    public List<Node> getTodayNodes() throws Exception {
        return this.filterNodeList(NodeLocation.getNodeListByLocationList(this.todayNodes));
    }

    public List<Node> getYesterdayNodes() throws Exception {
        return this.filterNodeList(NodeLocation.getNodeListByLocationList(this.yesterdayNodes));
    }

    public List<Node> getEarlierThisWeekNodes() throws Exception {
        return this.filterNodeList(NodeLocation.getNodeListByLocationList(this.earlierThisWeekNodes));
    }

    public List<Node> getEarlierThisMonthNodes() throws Exception {
        return this.filterNodeList(NodeLocation.getNodeListByLocationList(this.earlierThisMonthNodes));
    }

    public List<Node> getEarlierThisYearNodes() throws Exception {
        return this.filterNodeList(NodeLocation.getNodeListByLocationList(this.earlierThisYearNodes));
    }

    public void updateNodeLists() throws Exception {
        TimelineService timelineService = (TimelineService)this.getApplicationComponent(TimelineService.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        SessionProvider sessionProvider = uiExplorer.getSessionProvider();
        Session session = uiExplorer.getSession();
        String workspace = this.getWorkspaceName();
        String userName = session.getUserID();
        String nodePath = uiExplorer.getCurrentPath();
        String tagPath = uiExplorer.getTagPath();
        boolean isViewTag = uiExplorer.isViewTag();
        this.todayNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfToday(nodePath, workspace, sessionProvider, userName, false));
        this.yesterdayNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfYesterday(nodePath, workspace, sessionProvider, userName, false));
        this.earlierThisWeekNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisWeek(nodePath, workspace, sessionProvider, userName, false));
        this.earlierThisMonthNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisMonth(nodePath, workspace, sessionProvider, userName, false));
        this.earlierThisYearNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisYear(nodePath, workspace, sessionProvider, userName, false));
        if (isViewTag && tagPath != null) {
            if (this.todayNodes.size() > 0) {
                this.todayNodes = this.filterDocumentsByTag(this.todayNodes, tagPath);
            }
            if (this.yesterdayNodes.size() > 0) {
                this.yesterdayNodes = this.filterDocumentsByTag(this.yesterdayNodes, tagPath);
            }
            if (this.earlierThisWeekNodes.size() > 0) {
                this.earlierThisWeekNodes = this.filterDocumentsByTag(this.earlierThisWeekNodes, tagPath);
            }
            if (this.earlierThisMonthNodes.size() > 0) {
                this.earlierThisMonthNodes = this.filterDocumentsByTag(this.earlierThisMonthNodes, tagPath);
            }
            if (this.earlierThisYearNodes.size() > 0) {
                this.earlierThisYearNodes = this.filterDocumentsByTag(this.earlierThisYearNodes, tagPath);
            }
        }
        Collections.sort(this.todayNodes, new SearchComparator());
        Collections.sort(this.yesterdayNodes, new SearchComparator());
        Collections.sort(this.earlierThisWeekNodes, new SearchComparator());
        Collections.sort(this.earlierThisMonthNodes, new SearchComparator());
        Collections.sort(this.earlierThisYearNodes, new SearchComparator());
    }

    public List<NodeLocation> filterDocumentsByTag(List<NodeLocation> nodes, String path) throws Exception {
        ArrayList<Node> documents = new ArrayList<Node>();
        Session session = null;
        Node node = null;
        QueryManager queryManager = null;
        QueryResult queryResult = null;
        Query query = null;
        NodeIterator nodeIterator = null;
        for (int i = 0; i < nodes.size(); ++i) {
            node = NodeLocation.getNodeByLocation((NodeLocation)nodes.get(i));
            if (!node.isNodeType("mix:referenceable")) continue;
            session = node.getSession();
            String queryString = "SELECT * FROM exo:symlink where jcr:path like '" + path + "/%' and exo:uuid = '" + node.getUUID() + "' and exo:workspace='" + node.getSession().getWorkspace().getName() + "'";
            queryManager = session.getWorkspace().getQueryManager();
            query = queryManager.createQuery(queryString, "sql");
            queryResult = query.execute();
            nodeIterator = queryResult.getNodes();
            if (nodeIterator.getSize() <= 0L) continue;
            documents.add(node);
        }
        return NodeLocation.getLocationsByNodeList(documents);
    }

    public UIPageIterator getContentPageIterator() {
        return this.pageIterator_;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getUIComponent((String)mimeType, (UIContainer)this);
    }

    public String getTemplate() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer.getPreference().isJcrEnable()) {
            return uiExplorer.getDocumentInfoTemplate();
        }
        try {
            Node node = uiExplorer.getCurrentNode();
            String template = this.templateService.getTemplatePath(node, false);
            if (template != null) {
                return template;
            }
        }
        catch (AccessDeniedException ace) {
            try {
                uiExplorer.setSelectRootNode();
                Object[] args = new Object[]{uiExplorer.getCurrentNode().getName()};
                throw new MessageException(new ApplicationMessage("UIDocumentInfo.msg.access-denied", args, 1));
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uiExplorer.getDocumentInfoTemplate();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public UIRightClickPopupMenu getContextMenu() {
        return (UIRightClickPopupMenu)((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getChild(UIRightClickPopupMenu.class);
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String[] workspaces;
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        for (String ws : workspaces = manageRepo.getWorkspaceNames()) {
            try {
                return WCMCoreUtils.getSystemSessionProvider().getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public String getCapacityOfFile(Node file) throws Exception {
        Node contentNode = file.getNode("jcr:content");
        long size = contentNode.getProperty("jcr:data").getLength();
        long capacity = size / 1024L;
        String strCapacity = Long.toString(capacity);
        if (strCapacity.indexOf(".") > -1) {
            return strCapacity.substring(0, strCapacity.lastIndexOf("."));
        }
        return strCapacity;
    }

    public List<String> getMultiValues(Node node, String name) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getMultiValues(node, name);
    }

    public boolean isSystemWorkspace() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ManageableRepository manaRepoService = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        String systemWsName = manaRepoService.getConfiguration().getSystemWorkspaceName();
        return systemWsName.equals(uiExplorer.getCurrentWorkspace());
    }

    public boolean isSupportedThumbnailImage(Node node) throws Exception {
        if (node.getPrimaryNodeType().getName().equals("nt:file")) {
            Node contentNode = node.getNode("jcr:content");
            ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
            for (ComponentPlugin plugin : thumbnailService.getComponentPlugins()) {
                ThumbnailPlugin thumbnailPlugin;
                if (!(plugin instanceof ThumbnailPlugin) || !(thumbnailPlugin = (ThumbnailPlugin)plugin).getMimeTypes().contains(contentNode.getProperty("jcr:mimeType").getString())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isImageType(Node node) throws Exception {
        Node contentNode;
        return node.getPrimaryNodeType().getName().equals("nt:file") && (contentNode = node.getNode("jcr:content")).getProperty("jcr:mimeType").getString().startsWith("image");
    }

    public String getThumbnailImage(Node node) throws Exception {
        node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        return org.exoplatform.ecm.webui.utils.Utils.getThumbnailImage((Node)node, (String)"exo:mediumSize");
    }

    public Node getThumbnailNode(Node node) throws Exception {
        ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        if (!linkManager.isLink((Item)node) || linkManager.isTargetReachable(node)) {
            node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        }
        return thumbnailService.getThumbnailNode(node);
    }

    public String getDownloadLink(Node node) throws Exception {
        return Utils.getDownloadLink((Node)node);
    }

    public String getImage(Node node) throws Exception {
        return this.getImage(node, "exo:image");
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public Node getViewNode(String nodeType) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode().getNode(nodeType);
    }

    public Node getNodeByPath(String nodePath, String workspace) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspace, manageRepo);
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getNodeByPath(nodePath, session);
    }

    public String getActionsList(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getActionsExtensionList(node);
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getCustomActions(node);
    }

    public boolean isPreferenceNode(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).isPreferenceNode(node);
    }

    public boolean isReadAuthorized(ExtendedNode node) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isReadAuthorized(node);
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(className);
            service = this.getApplicationComponent(clazz);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unexpected error", (Throwable)ex);
        }
        return service;
    }

    public String getNodeOwner(Node node) throws RepositoryException {
        if (node.hasProperty("exo:owner")) {
            return node.getProperty("exo:owner").getString();
        }
        return IdentityConstants.ANONIM;
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public Date getDateModified(Node node) throws Exception {
        if (node.hasProperty("exo:dateModified")) {
            return node.getProperty("exo:dateModified").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        Node currentNode = this.getCurrentNode();
        if (currentNode.hasProperty("exo:relation")) {
            Value[] vals = currentNode.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                if (node == null) continue;
                relations.add(node);
            }
        }
        return relations;
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        Node currentNode = this.getCurrentNode();
        NodeIterator childrenIterator = currentNode.getNodes();
        int attachData = 0;
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = org.exoplatform.ecm.webui.utils.Utils.getListAllowedFileType((Node)currentNode, (TemplateService)this.templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            if (childNode.hasProperty("jcr:data")) {
                attachData = childNode.getProperty("jcr:data").getStream().available();
                if (attachData <= 0) continue;
                attachments.add(childNode);
                continue;
            }
            attachments.add(childNode);
        }
        return attachments;
    }

    @Deprecated
    public String getAttachmentURL(Node attNode, Parameter[] params) throws Exception {
        return this.getViewableLink(attNode, params);
    }

    public String getViewableLink(Node attNode, Parameter[] params) throws Exception {
        return this.event("ChangeNode", org.exoplatform.ecm.webui.utils.Utils.formatNodeName((String)attNode.getPath()), params);
    }

    public boolean isNodeTypeSupported(String nodeTypeName) {
        try {
            return this.templateService.isManagedNodeType(nodeTypeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public List<String> getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.getCurrentNode());
    }

    public String getTemplatePath() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public String getVersionName(Node node) throws Exception {
        return node.getBaseVersion().getName();
    }

    public boolean hasAuditHistory(Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        AuditService auServ = (AuditService)container.getComponentInstanceOfType(AuditService.class);
        node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        return auServ.hasHistory(node);
    }

    public int getNumAuditHistory(Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        AuditService auServ = (AuditService)container.getComponentInstanceOfType(AuditService.class);
        Node node2 = node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        if (auServ.hasHistory(node)) {
            AuditHistory auHistory = auServ.getHistory(node);
            return auHistory.getAuditRecords().size();
        }
        return 0;
    }

    public void setNode(Node node) {
        this.currentNode_ = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public boolean isRssLink() {
        return false;
    }

    public String getRssLink() {
        return null;
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRepository() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String getWorkspaceName() throws Exception {
        if (this.currentNode_ == null) {
            return this.getOriginalNode().getSession().getWorkspace().getName();
        }
        return this.getCurrentNode().getSession().getWorkspace().getName();
    }

    public Node getNode() throws Exception {
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        this.currentNode_ = NodeLocation.getNodeLocationByNode((Node)currentNode);
        if (currentNode.hasProperty("exo:language")) {
            String defaultLang = currentNode.getProperty("exo:language").getString();
            if (this.getLanguage() == null) {
                this.setLanguage(defaultLang);
            }
            if (!this.getLanguage().equals(defaultLang)) {
                MultiLanguageService multiServ = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
                Node curNode = multiServ.getLanguage(currentNode, this.getLanguage());
                if (currentNode.isNodeType("nt:folder") || currentNode.isNodeType("nt:unstructured")) {
                    try {
                        return curNode.getNode(currentNode.getName());
                    }
                    catch (Exception e) {
                        return curNode;
                    }
                }
                return curNode;
            }
        }
        return currentNode;
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode_);
    }

    public Node getOriginalNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public String getIcons(Node node, String size) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)size);
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.getCurrentNode(), this.getLanguage());
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage());
    }

    public String getLanguage() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getLanguage();
    }

    public void setLanguage(String language) {
        ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).setLanguage(language);
    }

    public boolean isCanPaste() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getAllClipBoard().size() > 0;
    }

    public void updatePageListData() throws Exception {
        Set<String> allItemByTypeFilterMap;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        int nodesPerPage = uiExplorer.getPreference().getNodesPerPage();
        List<Object> nodeList = new ArrayList();
        Preference pref = uiExplorer.getPreference();
        String currentPath = uiExplorer.getCurrentPath();
        nodeList = !uiExplorer.isViewTag() ? ((allItemByTypeFilterMap = uiExplorer.getAllItemByTypeFilterMap()).size() > 0 ? this.filterNodeList(uiExplorer.getChildrenList(currentPath, !pref.isShowPreferenceDocuments())) : this.filterNodeList(uiExplorer.getChildrenList(currentPath, pref.isShowPreferenceDocuments()))) : uiExplorer.getDocumentByTag();
        ListAccessImpl nodeAccList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(nodeList));
        this.pageIterator_.setPageList((PageList)new LazyPageList((ListAccess)nodeAccList, nodesPerPage));
    }

    public List<Node> getChildrenList() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.pageIterator_.getCurrentPageData());
    }

    public String getTypeSort() {
        return this.typeSort_;
    }

    public void setTypeSort(String typeSort) {
        this.typeSort_ = typeSort;
    }

    public String getSortOrder() {
        return this.sortOrder_;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder_ = sortOrder;
    }

    public String encodeHTML(String text) {
        return org.exoplatform.ecm.webui.utils.Utils.encodeHTML((String)text);
    }

    public UIComponent getCommentComponent() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIActionBar uiActionBar = (UIActionBar)uiExplorer.findFirstComponentOfType(UIActionBar.class);
        UIComponent uicomponent = uiActionBar.getUIAction(COMMENT_COMPONENT);
        return uicomponent != null ? uicomponent : this;
    }

    public boolean isEnableThumbnail() {
        ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
        return thumbnailService.isEnableThumbnail();
    }

    public String getFlowImage(Node node) throws Exception {
        node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        return org.exoplatform.ecm.webui.utils.Utils.getThumbnailImage((Node)node, (String)"exo:bigSize");
    }

    public String getThumbnailSize(Node node) throws Exception {
        node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        String imageSize = null;
        if (node.hasProperty("exo:bigSize")) {
            BufferedImage image = ImageIO.read(node.getProperty("exo:bigSize").getStream());
            imageSize = Integer.toString(((Image)image).getWidth(null)) + "x" + Integer.toString(((Image)image).getHeight(null));
        }
        return imageSize;
    }

    public DateFormat getSimpleDateFormat() {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        return SimpleDateFormat.getDateTimeInstance(3, 3, locale);
    }

    public boolean isSymLink(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "DocumentInfoRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIDocumentContainer.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "DocumentInfoRemoveComment");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIDocumentContainer.class, UIWorkingArea.class));
        return uicomponent;
    }

    public boolean isFavouriter(Node data) throws Exception {
        return this.isFavouriteNode(((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getSession().getUserID(), data);
    }

    public boolean isFavouriteNode(String userName, Node node) throws Exception {
        return ((FavoriteService)this.getApplicationComponent(FavoriteService.class)).isFavoriter(userName, node);
    }

    public boolean isMediaType(Node data) throws Exception {
        if (!data.isNodeType("nt:file")) {
            return false;
        }
        String mimeType = data.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        return manager.accept("org.exoplatform.ecm.dms.FileViewer", "VideoAudio", context);
    }

    public String getPropertyNameWithoutNamespace(String propertyName) {
        if (propertyName.indexOf(":") > -1) {
            return propertyName.split(":")[1];
        }
        return propertyName;
    }

    public String getPropertyValue(Node node, String propertyName) throws Exception {
        try {
            Property property = node.getProperty(propertyName);
            if (property != null) {
                int requiredType = property.getDefinition().getRequiredType();
                switch (requiredType) {
                    case 1: {
                        return property.getString();
                    }
                    case 5: {
                        return this.getSimpleDateFormat().format(property.getDate().getTime());
                    }
                }
            }
        }
        catch (PathNotFoundException PNE) {
            return "";
        }
        return "";
    }

    public DriveData getDrive(List<DriveData> lstDrive, Node node) throws RepositoryException {
        DriveData driveData = null;
        for (DriveData drive : lstDrive) {
            if (!node.getSession().getWorkspace().getName().equals(drive.getWorkspace()) || !node.getPath().contains(drive.getHomePath()) || !drive.getHomePath().equals("/")) continue;
            driveData = drive;
            break;
        }
        return driveData;
    }

    private List<Node> filterNodeList(List<Node> sourceNodeList) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        if (!this.hasFilters()) {
            return sourceNodeList;
        }
        for (Node node : sourceNodeList) {
            try {
                if (!this.filterOk(node)) continue;
                ret.add(node);
            }
            catch (Exception ex) {}
        }
        return ret;
    }

    private boolean hasFilters() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Set<String> allItemsFilterSet = uiExplorer.getAllItemFilterMap();
        Set<String> allItemsByTypeFilterSet = uiExplorer.getAllItemByTypeFilterMap();
        return allItemsByTypeFilterSet.size() > 0 || allItemsFilterSet.size() > 0;
    }

    private boolean filterOk(Node node) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Set<String> allItemsFilterSet = uiExplorer.getAllItemFilterMap();
        Set<String> allItemsByTypeFilterSet = uiExplorer.getAllItemByTypeFilterMap();
        String userId = uiExplorer.getSession().getUserID();
        if (allItemsFilterSet.contains("OwnedByMe") && !userId.equals(node.getProperty("exo:owner").getString())) {
            return false;
        }
        if (allItemsFilterSet.contains("Favorites") && !this.favoriteService.isFavoriter(userId, node)) {
            return false;
        }
        for (String documentType : allItemsByTypeFilterSet) {
            boolean found = false;
            if (this.documentTypeService.isContentsType(documentType)) {
                for (String documentNodeType : this.templateService.getAllDocumentNodeTypes()) {
                    if (!node.isNodeType(documentNodeType)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                for (String mimeType : this.documentTypeService.getMimeTypes(documentType)) {
                    if (node.getNode("jcr:content").getProperty("jcr:mimeType").getString().indexOf(mimeType) < 0) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean isEnableComment() {
        return true;
    }

    public boolean isEnableVote() {
        return true;
    }

    public void setEnableComment(boolean value) {
    }

    public void setEnableVote(boolean value) {
    }

    public String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName, (String)defaultValue, (String)inputType, (String)idGenerator, (String)cssClass, (boolean)isGenericProperty, (String[])arguments);
    }

    public String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchComparator
    implements Comparator<NodeLocation> {
        private SearchComparator() {
        }

        @Override
        public int compare(NodeLocation nodeA, NodeLocation nodeB) {
            try {
                Node node1 = NodeLocation.getNodeByLocation((NodeLocation)nodeA);
                Node node2 = NodeLocation.getNodeByLocation((NodeLocation)nodeB);
                if (UIDocumentInfo.this.timeLineSortByFavourite.length() != 0) {
                    int factor;
                    int n = factor = UIDocumentInfo.this.timeLineSortByFavourite.equals("BlueDownArrow") ? 1 : -1;
                    if (UIDocumentInfo.this.isFavouriter(node1)) {
                        return -1 * factor;
                    }
                    if (UIDocumentInfo.this.isFavouriter(node2)) {
                        return 1 * factor;
                    }
                    return 0;
                }
                if (UIDocumentInfo.this.timeLineSortByDate.length() != 0) {
                    int factor = UIDocumentInfo.this.timeLineSortByDate.equals("BlueDownArrow") ? 1 : -1;
                    Calendar c1 = node1.getProperty("exo:dateModified").getValue().getDate();
                    Calendar c2 = node2.getProperty("exo:dateModified").getValue().getDate();
                    return factor * c1.compareTo(c2);
                }
                if (UIDocumentInfo.this.timeLineSortByName.length() != 0) {
                    int factor = UIDocumentInfo.this.timeLineSortByName.equals("BlueDownArrow") ? 1 : -1;
                    String s1 = node1.getName();
                    String s2 = node2.getName();
                    return factor * s1.compareTo(s2);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot compare nodes", (Throwable)e);
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowPageActionListener
    extends EventListener<UIPageIterator> {
        public void execute(Event<UIPageIterator> event) throws Exception {
            UIPageIterator uiPageIterator = (UIPageIterator)event.getSource();
            UIApplication uiApp = (UIApplication)uiPageIterator.getAncestorOfType(UIApplication.class);
            UIJCRExplorer explorer = (UIJCRExplorer)uiPageIterator.getAncestorOfType(UIJCRExplorer.class);
            UITreeExplorer treeExplorer = (UITreeExplorer)explorer.findFirstComponentOfType(UITreeExplorer.class);
            try {
                if (treeExplorer == null) {
                    return;
                }
                String componentId = explorer.getCurrentNode().getPath();
                UITreeNodePageIterator extendedPageIterator = treeExplorer.getUIPageIterator(componentId);
                if (extendedPageIterator == null) {
                    return;
                }
                int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
                extendedPageIterator.setCurrentPage(page);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)treeExplorer);
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortTimelineDESCActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            String objectID = event.getRequestContext().getRequestParameter("objectId");
            if (objectID.equals("favourite")) {
                uiDocumentInfo.timeLineSortByFavourite = "BlueUpArrow";
                uiDocumentInfo.timeLineSortByName = "";
                uiDocumentInfo.timeLineSortByDate = "";
            } else if (objectID.equals("name")) {
                uiDocumentInfo.timeLineSortByFavourite = "";
                uiDocumentInfo.timeLineSortByName = "BlueUpArrow";
                uiDocumentInfo.timeLineSortByDate = "";
            } else if (objectID.equals("dateTime")) {
                uiDocumentInfo.timeLineSortByFavourite = "";
                uiDocumentInfo.timeLineSortByName = "";
                uiDocumentInfo.timeLineSortByDate = "BlueUpArrow";
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortTimelineASCActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            String objectID = event.getRequestContext().getRequestParameter("objectId");
            if (objectID.equals("favourite")) {
                uiDocumentInfo.timeLineSortByFavourite = "BlueDownArrow";
                uiDocumentInfo.timeLineSortByName = "";
                uiDocumentInfo.timeLineSortByDate = "";
            } else if (objectID.equals("name")) {
                uiDocumentInfo.timeLineSortByFavourite = "";
                uiDocumentInfo.timeLineSortByName = "BlueDownArrow";
                uiDocumentInfo.timeLineSortByDate = "";
            } else if (objectID.equals("dateTime")) {
                uiDocumentInfo.timeLineSortByFavourite = "";
                uiDocumentInfo.timeLineSortByName = "";
                uiDocumentInfo.timeLineSortByDate = "BlueDownArrow";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StarClickActionListener
    extends EventListener<UIDocumentInfo> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentInfo.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiDocumentInfo.getAncestorOfType(UIApplication.class);
            FavoriteService favoriteService = (FavoriteService)uiDocumentInfo.getApplicationComponent(FavoriteService.class);
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
            String wsName = null;
            Node node = null;
            if (!matcher.find()) {
                throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
            }
            wsName = matcher.group(1);
            srcPath = matcher.group(2);
            Session session = null;
            try {
                session = uiExplorer.getSessionByWorkspace(wsName);
                node = uiExplorer.getNodeByPath(srcPath, session, false);
                srcPath = node.getPath();
                session = node.getSession();
                wsName = session.getWorkspace().getName();
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                return;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            try {
                uiExplorer.addLockToken(node);
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            try {
                if (favoriteService.isFavoriter(node.getSession().getUserID(), node)) {
                    if (!PermissionUtil.canRemoveNode((Node)node)) throw new AccessDeniedException();
                    favoriteService.removeFavorite(node, node.getSession().getUserID());
                } else {
                    if (!PermissionUtil.canSetProperty((Node)node)) throw new AccessDeniedException();
                    favoriteService.addFavorite(node, node.getSession().getUserID());
                }
                event.getRequestContext().addUIComponentToUpdateByAjax(uiDocumentInfo.getParent());
                return;
            }
            catch (AccessDeniedException e) {
                LOG.error((Object)("Access denied! No permission for modifying property exo:favouriter of node: " + node.getPath()));
                uiApp.addMessage(new ApplicationMessage("UIShowAllFavouriteResult.msg.accessDenied", null, 1));
                return;
            }
            catch (VersionException ve) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-verion-exception", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (ReferentialIntegrityException ref) {
                session.refresh(false);
                uiExplorer.refreshExplorer();
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-referentialIntegrityException", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (ConstraintViolationException cons) {
                session.refresh(false);
                uiExplorer.refreshExplorer();
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (LockException lockException) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked-other-person", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiComp = (UIDocumentInfo)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiComp.getAncestorOfType(UIApplication.class);
            try {
                String downloadLink = uiComp.getDownloadLink(Utils.getFileLangNode((Node)uiComp.getNode()));
                event.getRequestContext().getJavascriptManager().addCustomizedOnLoadScript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VoteActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiComp = (UIDocumentInfo)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiComp.getAncestorOfType(UIApplication.class);
            try {
                String userName = Util.getPortalRequestContext().getRemoteUser();
                double objId = Double.parseDouble(event.getRequestContext().getRequestParameter("objectId"));
                VotingService votingService = (VotingService)uiComp.getApplicationComponent(VotingService.class);
                votingService.vote(uiComp.getCurrentNode(), objId, userName, uiComp.getLanguage());
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentInfo.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiDocumentInfo.getAncestorOfType(UIApplication.class);
            try {
                String selectedLanguage = event.getRequestContext().getRequestParameter("objectId");
                uiExplorer.setLanguage(selectedLanguage);
                uiExplorer.updateAjax(event);
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uicomp = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            try {
                String sortParam = event.getRequestContext().getRequestParameter("objectId");
                String[] array = sortParam.split(";");
                String order = "";
                order = array[0].trim().equals("Ascending") ? "BlueDownArrow" : "BlueUpArrow";
                uicomp.setSortOrder(order);
                uicomp.setTypeSort(array[1]);
                Preference pref = uiExplorer.getPreference();
                if (array.length != 2) {
                    return;
                }
                pref.setSortType(array[1].trim());
                pref.setOrder(array[0].trim());
                uiExplorer.updateAjax(event);
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uicomp = (UIDocumentInfo)((Object)event.getSource());
            NodeFinder nodeFinder = (NodeFinder)uicomp.getApplicationComponent(NodeFinder.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            boolean findDrive = Boolean.getBoolean(event.getRequestContext().getRequestParameter("findDrive"));
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            try {
                uri = LinkUtils.evaluatePath((String)uri);
                Item item = nodeFinder.getItem(workspaceName, uri);
                if (item instanceof Node && org.exoplatform.ecm.webui.utils.Utils.isInTrash((Node)((Node)item))) {
                    return;
                }
                uiExplorer.setSelectNode(workspaceName, uri);
                if (findDrive) {
                    ManageDriveService manageDriveService = (ManageDriveService)uicomp.getApplicationComponent(ManageDriveService.class);
                    List driveList = manageDriveService.getDriveByUserRoles(Util.getPortalRequestContext().getRemoteUser(), org.exoplatform.ecm.webui.utils.Utils.getMemberships());
                    DriveData drive = uicomp.getDrive(driveList, uiExplorer.getCurrentNode());
                    String warningMSG = null;
                    if (driveList.size() == 0) {
                        warningMSG = "UIDocumentInfo.msg.access-denied";
                    } else if (drive == null) {
                        warningMSG = "UIPopupMenu.msg.path-not-found-exception";
                    }
                    if (warningMSG != null) {
                        uiApp.addMessage(new ApplicationMessage(warningMSG, null, 1));
                        return;
                    }
                    uiExplorer.setDriveData(uicomp.getDrive(driveList, uiExplorer.getCurrentNode()));
                }
                uiExplorer.updateAjax(event);
            }
            catch (ItemNotFoundException nu) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                return;
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.path-not-found", null, 1));
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                return;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewNodeActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uicomp = (UIDocumentInfo)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            try {
                String uri = event.getRequestContext().getRequestParameter("objectId");
                String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
                uiExplorer.setSelectNode(workspaceName, uri);
                uiExplorer.updateAjax(event);
                event.broadcast();
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Repository cannot be found");
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }
}

