/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.artifact;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.ext.artifact.Descriptor;
import org.exoplatform.services.jcr.ext.artifact.FolderDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ArtifactDescriptor
implements Descriptor {
    private final FolderDescriptor groupId;
    private final String artifactId;
    private final String versionId;

    public ArtifactDescriptor(FolderDescriptor groupId, String artifactId, String versionId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.versionId = versionId;
    }

    public FolderDescriptor getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getAsString() {
        return this.groupId.getAsString() + "-" + this.artifactId + "-" + this.versionId;
    }

    public String getAsPath() {
        if (StringUtils.isBlank((String)this.artifactId) || StringUtils.isBlank((String)this.versionId)) {
            return this.groupId.getAsString();
        }
        return this.groupId.getAsPath() + "/" + this.artifactId + "/" + this.versionId;
    }

    public static ArtifactDescriptor createFromPomfile(File pomfile) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(pomfile);
        NodeList groupIdList = doc.getElementsByTagName("groupId");
        String groupId = groupIdList.item(0).getTextContent().trim();
        NodeList artifactIdList = doc.getElementsByTagName("artifactId");
        String artifactId = "";
        for (int i = 0; i < artifactIdList.getLength(); ++i) {
            if (!artifactIdList.item(i).getParentNode().getNodeName().equals("project")) continue;
            artifactId = artifactIdList.item(i).getTextContent().trim();
        }
        NodeList versionList = doc.getElementsByTagName("version");
        String versionId = ArtifactDescriptor.validMavenVersion(versionList.item(0).getTextContent().trim());
        return new ArtifactDescriptor(new FolderDescriptor(groupId), artifactId, versionId);
    }

    private static String validMavenVersion(String version) {
        return version;
    }
}

