/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.url.navigation;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.navigation.NavigationResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeURL
extends PortalURL<NavigationResource, NodeURL> {
    public static final QualifiedName PATH = QualifiedName.create("gtn", "path");
    public static final QualifiedName REQUEST_SITE_TYPE = QualifiedName.create("gtn", "sitetype");
    public static final QualifiedName REQUEST_SITE_NAME = QualifiedName.create("gtn", "sitename");
    public static final ResourceType<NavigationResource, NodeURL> TYPE = new ResourceType<NavigationResource, NodeURL>(){};
    private static final Set<QualifiedName> PARAMETER_NAMES = new HashSet<QualifiedName>();
    private NavigationResource resource;

    public NodeURL(URLContext context) throws NullPointerException {
        super(context);
    }

    @Override
    public Set<QualifiedName> getParameterNames() {
        return PARAMETER_NAMES;
    }

    @Override
    public String getParameterValue(QualifiedName parameterName) {
        if (PATH.equals(parameterName)) {
            if (this.resource.getNodeURI() == null) {
                return "";
            }
            return this.resource.getNodeURI();
        }
        if (REQUEST_SITE_TYPE.equals(parameterName)) {
            return this.resource.getSiteType().getName();
        }
        if (REQUEST_SITE_NAME.equals(parameterName)) {
            return this.resource.getSiteName();
        }
        return null;
    }

    @Override
    public NavigationResource getResource() {
        return this.resource;
    }

    @Override
    public NodeURL setResource(NavigationResource resource) {
        this.resource = resource;
        return this;
    }

    public NodeURL setNode(UserNode node) {
        this.resource = new NavigationResource(node);
        return this;
    }

    static {
        PARAMETER_NAMES.add(PATH);
        PARAMETER_NAMES.add(REQUEST_SITE_TYPE);
        PARAMETER_NAMES.add(REQUEST_SITE_NAME);
    }
}

