/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;

public class ParticipantGmsImpl
extends GmsImpl {
    private final Vector<Address> suspected_mbrs = new Vector(11);
    private final Promise<Boolean> leave_promise = new Promise();

    public ParticipantGmsImpl(GMS g) {
        super(g);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.suspected_mbrs.removeAllElements();
        this.leave_promise.reset();
    }

    @Override
    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    @Override
    public void joinWithStateTransfer(Address mbr) {
        this.wrongMethod("join");
    }

    @Override
    public void leave(Address mbr) {
        Address coord;
        int max_tries = 3;
        this.leave_promise.reset();
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        while ((coord = this.gms.determineCoordinator()) != null && max_tries-- > 0) {
            if (this.gms.local_addr.equals(coord)) {
                this.gms.becomeCoordinator();
                this.gms.getImpl().leave(mbr);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sending LEAVE request to " + coord + " (local_addr=" + this.gms.local_addr + ")"));
            }
            this.sendLeaveMessage(coord, mbr);
            Boolean result = this.leave_promise.getResult(this.gms.leave_timeout);
            if (result == null) continue;
        }
        this.gms.becomeClient();
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        ViewId tmp_vid;
        View v = join_rsp.getView();
        ViewId viewId = tmp_vid = v != null ? v.getVid() : null;
        if (tmp_vid != null && this.gms.view_id != null && tmp_vid.compareTo(this.gms.view_id) > 0) {
            this.gms.installView(v);
        }
    }

    @Override
    public void handleLeaveResponse() {
        this.leave_promise.setResult(true);
    }

    @Override
    public void suspect(Address mbr) {
        LinkedHashSet<GmsImpl.Request> suspected = new LinkedHashSet<GmsImpl.Request>(1);
        suspected.add(new GmsImpl.Request(3, mbr, true, null));
        this.handleMembershipChange(suspected);
    }

    @Override
    public void unsuspect(Address mbr) {
        if (mbr != null) {
            this.suspected_mbrs.remove(mbr);
        }
    }

    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
        LinkedHashSet<Address> suspectedMembers = new LinkedHashSet<Address>(requests.size());
        for (GmsImpl.Request req : requests) {
            if (req.type != 3) continue;
            suspectedMembers.add(req.mbr);
        }
        if (suspectedMembers.isEmpty()) {
            return;
        }
        for (Address mbr : suspectedMembers) {
            if (this.suspected_mbrs.contains(mbr)) continue;
            this.suspected_mbrs.addElement(mbr);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("suspected members=" + suspectedMembers + ", suspected_mbrs=" + this.suspected_mbrs));
        }
        if (this.wouldIBeCoordinator()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("members are " + this.gms.members + ", coord=" + this.gms.local_addr + ": I'm the new coord !"));
            }
            this.suspected_mbrs.removeAllElements();
            this.gms.becomeCoordinator();
            for (Address mbr : suspectedMembers) {
                this.gms.getViewHandler().add(new GmsImpl.Request(3, mbr, true, null));
                this.gms.ack_collector.suspect(mbr);
            }
        }
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        Vector<Address> mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("view=" + new_view));
        }
        this.suspected_mbrs.removeAllElements();
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    @Override
    public void handleMergeRequest(Address sender, ViewId merge_id) {
        this.sendMergeRejectedResponse(sender, merge_id);
    }

    boolean wouldIBeCoordinator() {
        Vector<Address> mbrs = this.gms.members.getMembers();
        mbrs.removeAll(this.suspected_mbrs);
        if (mbrs.size() < 1) {
            return false;
        }
        Address new_coord = mbrs.firstElement();
        return this.gms.local_addr.equals(new_coord);
    }

    void sendLeaveMessage(Address coord, Address mbr) {
        Message msg = new Message(coord, null, null);
        msg.setFlag((byte)1);
        GMS.GmsHeader hdr = new GMS.GmsHeader(3, mbr);
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }
}

