/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.parser.quasiliteral.SimpleQuasiNode;
import com.google.caja.util.CajaTestCase;
import java.net.URI;
import java.util.Arrays;

public class QuasiBuilderTest
extends CajaTestCase {
    public final void testParseDoesNotFail() throws Exception {
        QuasiNode n = QuasiBuilder.parseQuasiNode(new InputSource(URI.create("built-in:///js-quasi-literals")), "function @a() { @b.@c = @d; @e = @f; }");
        QuasiBuilderTest.assertTrue((boolean)(n instanceof SimpleQuasiNode));
    }

    public final void testMultiProps() throws Exception {
        ParseTreeNode n = QuasiBuilder.substV("({ '@k*': @v*, baz: @boo })", "k", new ParseTreeNodeContainer(Arrays.asList(this.jsExpr(this.fromString("'foo'")), this.jsExpr(this.fromString("'bar'")))), "v", new ParseTreeNodeContainer(Arrays.asList(this.jsExpr(this.fromString("0")), this.jsExpr(this.fromString("1")))), "boo", new IntegerLiteral(FilePosition.UNKNOWN, 2L));
        QuasiBuilderTest.assertEquals((String)QuasiBuilderTest.render(this.jsExpr(this.fromString("{ foo: 0, bar: 1, baz: 2 }"))), (String)QuasiBuilderTest.render(n));
    }

    public final void testPropKeys() throws Exception {
        ParseTreeNode n = QuasiBuilder.substV("({ @a: @b, '\\@c': @d })", "a", StringLiteral.valueOf(FilePosition.UNKNOWN, "a"), "b", StringLiteral.valueOf(FilePosition.UNKNOWN, "b"), "c", StringLiteral.valueOf(FilePosition.UNKNOWN, "c"), "d", StringLiteral.valueOf(FilePosition.UNKNOWN, "d"));
        QuasiBuilderTest.assertEquals((String)QuasiBuilderTest.render(this.jsExpr(this.fromString("{ a: 'b', '@c': 'd' }"))), (String)QuasiBuilderTest.render(n));
    }
}

