/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Parser;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.stages.HtmlEmbeddedContentFinder;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.ContentType;
import com.google.caja.util.Function;
import java.net.URI;
import java.util.Collections;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedContent {
    private final HtmlEmbeddedContentFinder finder;
    private final FilePosition pos;
    private final Function<UriFetcher, CharProducer> getter;
    private final ExternalReference contentLocation;
    private final boolean deferred;
    private final Node source;
    private final ContentType type;

    EmbeddedContent(HtmlEmbeddedContentFinder finder, FilePosition pos, Function<UriFetcher, CharProducer> getter, ExternalReference contentLocation, boolean deferred, Node source, ContentType type) {
        this.finder = finder;
        this.pos = pos;
        this.getter = getter;
        this.deferred = deferred;
        this.contentLocation = contentLocation;
        this.source = source;
        this.type = type;
    }

    public URI getBaseUri() {
        return this.contentLocation != null ? this.contentLocation.getUri() : this.finder.getBaseUri();
    }

    public FilePosition getPosition() {
        return this.pos;
    }

    public CharProducer getContent(UriFetcher env) {
        return this.getter.apply(env);
    }

    public ExternalReference getContentLocation() {
        return this.contentLocation;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public Node getSource() {
        return this.source;
    }

    public ParseTreeNode parse(UriFetcher fetcher, MessageQueue mq) throws ParseException {
        if (this.type == null) {
            return null;
        }
        CharProducer cp = this.getContent(fetcher);
        FilePosition p = cp.filePositionForOffsets(cp.getOffset(), cp.getLimit());
        switch (this.type) {
            case JS: {
                Parser parser = this.finder.makeJsParser(cp, mq);
                if (parser.getTokenQueue().isEmpty()) {
                    return new Block(p);
                }
                return parser.parse();
            }
            case CSS: {
                CssParser parser = this.finder.makeCssParser(cp, mq);
                if (this.source.getNodeType() == 1) {
                    if (parser.getTokenQueue().isEmpty()) {
                        return new CssTree.StyleSheet(p, Collections.emptyList());
                    }
                    return parser.parseStyleSheet();
                }
                if (parser.getTokenQueue().isEmpty()) {
                    return new CssTree.DeclarationGroup(p, Collections.emptyList());
                }
                return parser.parseDeclarationGroup();
            }
        }
        throw new SomethingWidgyHappenedError(this.type.toString());
    }

    public ContentType getType() {
        return this.type;
    }
}

