/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.ecm.publication.AlreadyInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationPresentationService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicationServiceImpl
implements PublicationService {
    private static final String PUBLICATION = "publication:publication";
    private static final String LIFECYCLE_NAME = "publication:lifecycleName";
    private static final String CURRENT_STATE = "publication:currentState";
    private static final String HISTORY = "publication:history";
    protected static Log log;
    private PublicationPresentationService publicationPresentationService;
    private final String localeFile = "locale.portlet.publication.PublicationService";
    Map<String, PublicationPlugin> publicationPlugins_;

    public PublicationServiceImpl(PublicationPresentationService presentationService) {
        log = ExoLogger.getLogger((String)"portal:PublicationServiceImpl");
        log.info((Object)"# PublicationService initialization #");
        this.publicationPresentationService = presentationService;
        this.publicationPlugins_ = new HashMap<String, PublicationPlugin>();
    }

    @Override
    public void addLog(Node node, String[] args) throws NotInPublicationLifecycleException, Exception {
        Session session = node.getSession();
        ManageableRepository repository = (ManageableRepository)session.getRepository();
        Session systemSession = repository.getSystemSession(session.getWorkspace().getName());
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        ArrayList<Value> newValues = new ArrayList<Value>();
        Value[] values = node.getProperty(HISTORY).getValues();
        newValues.addAll(Arrays.asList(values));
        StringBuffer string2add = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                string2add.append(args[i]);
                continue;
            }
            string2add.append(",").append(args[i]);
        }
        Value value2add = systemSession.getValueFactory().createValue(string2add.toString());
        newValues.add(value2add);
        node.setProperty(HISTORY, newValues.toArray(new Value[newValues.size()]));
        systemSession.logout();
    }

    @Override
    public void addPublicationPlugin(PublicationPlugin p) {
        this.publicationPlugins_.put(p.getLifecycleName(), p);
        this.publicationPresentationService.addPublicationPlugin(p);
    }

    @Override
    public void changeState(Node node, String newState, HashMap<String, String> context) throws NotInPublicationLifecycleException, IncorrectStateUpdateLifecycleException, Exception {
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        String lifecycleName = this.getNodeLifecycleName(node);
        PublicationPlugin nodePlugin = this.publicationPlugins_.get(lifecycleName);
        nodePlugin.changeState(node, newState, context);
    }

    @Override
    public void enrollNodeInLifecycle(Node node, String lifecycle) throws AlreadyInPublicationLifecycleException, Exception {
        if (this.isNodeEnrolledInLifecycle(node)) {
            throw new AlreadyInPublicationLifecycleException();
        }
        if (!this.publicationPlugins_.get(lifecycle).canAddMixin(node)) {
            throw new NoSuchNodeTypeException();
        }
        this.publicationPlugins_.get(lifecycle).addMixin(node);
        node.setProperty(LIFECYCLE_NAME, lifecycle);
        node.setProperty(CURRENT_STATE, "enrolled");
        ArrayList history = new ArrayList();
        node.setProperty(HISTORY, history.toArray(new Value[history.size()]));
        node.getSession().save();
        this.publicationPlugins_.get(lifecycle).changeState(node, "enrolled", new HashMap<String, String>());
    }

    @Override
    public void unsubcribeLifecycle(Node node) throws NotInPublicationLifecycleException, Exception {
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        String lifecycleName = this.getNodeLifecycleName(node);
        log.info((Object)("The document: " + node.getName() + " unsubcribe publication lifecycle: " + lifecycleName));
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!nodeType.isNodeType(PUBLICATION)) continue;
            node.removeMixin(nodeType.getName());
        }
        node.getSession().save();
    }

    @Override
    public String getCurrentState(Node node) throws NotInPublicationLifecycleException, Exception {
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        return node.getProperty(CURRENT_STATE).getString();
    }

    @Override
    public String[][] getLog(Node node) throws NotInPublicationLifecycleException, Exception {
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        Value[] values = node.getProperty(HISTORY).getValues();
        String[][] result = new String[values.length][];
        for (int i = 0; i < values.length; ++i) {
            Value currentValue = values[i];
            String currentString = currentValue.getString();
            String[] currentStrings = currentString.split(",");
            result[i] = currentStrings;
        }
        return result;
    }

    @Override
    public String getNodeLifecycleDesc(Node node) throws NotInPublicationLifecycleException, Exception {
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        String lifecycleName = this.getNodeLifecycleName(node);
        PublicationPlugin nodePlugin = this.publicationPlugins_.get(lifecycleName);
        return nodePlugin.getNodeLifecycleDesc(node);
    }

    @Override
    public String getNodeLifecycleName(Node node) throws NotInPublicationLifecycleException, Exception {
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        return node.getProperty(LIFECYCLE_NAME).getString();
    }

    @Override
    public Map<String, PublicationPlugin> getPublicationPlugins() {
        return this.publicationPlugins_;
    }

    @Override
    public byte[] getStateImage(Node node, Locale locale) throws NotInPublicationLifecycleException, Exception {
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        String lifecycleName = this.getNodeLifecycleName(node);
        PublicationPlugin nodePlugin = this.publicationPlugins_.get(lifecycleName);
        return nodePlugin.getStateImage(node, locale);
    }

    @Override
    public String getUserInfo(Node node, Locale locale) throws NotInPublicationLifecycleException, Exception {
        if (!this.isNodeEnrolledInLifecycle(node)) {
            throw new NotInPublicationLifecycleException();
        }
        String lifecycleName = this.getNodeLifecycleName(node);
        PublicationPlugin nodePlugin = this.publicationPlugins_.get(lifecycleName);
        return nodePlugin.getUserInfo(node, locale);
    }

    @Override
    public boolean isNodeEnrolledInLifecycle(Node node) throws Exception {
        return node.isNodeType(PUBLICATION);
    }

    @Override
    public String getLocalizedAndSubstituteLog(Locale locale, String key, String[] values) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
        ClassLoader cl = this.getClass().getClassLoader();
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle("locale.portlet.publication.PublicationService", locale, cl);
        String result = resourceBundle.getString(key);
        return String.format(result, values);
    }

    @Override
    public String getLocalizedAndSubstituteLog(Node node, Locale locale, String key, String[] values) throws NotInPublicationLifecycleException, Exception {
        String lifecycleName = this.getNodeLifecycleName(node);
        PublicationPlugin publicationPlugin = this.publicationPlugins_.get(lifecycleName);
        try {
            return publicationPlugin.getLocalizedAndSubstituteMessage(locale, key, values);
        }
        catch (Exception e) {
            log.warn((Object)"Exception when get log message", (Throwable)e);
            return key;
        }
    }

    @Override
    public boolean isUnsubcribeLifecycle(Node node) throws Exception {
        return !this.isNodeEnrolledInLifecycle(node);
    }

    @Override
    public Node getNodePublish(Node node, String pluginName) throws Exception {
        if (node.isNodeType(PUBLICATION)) {
            PublicationPlugin publicationPlugin;
            if (pluginName == null || pluginName.trim().equals("")) {
                String lifecycleName = node.getProperty(LIFECYCLE_NAME).getString();
                publicationPlugin = this.publicationPlugins_.get(lifecycleName);
            } else {
                publicationPlugin = this.publicationPlugins_.get(pluginName);
            }
            return publicationPlugin.getNodeView(node, null);
        }
        return null;
    }
}

