/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;

public class InitialNewsletterPlugin
extends CreatePortalPlugin {
    private List<NewsletterCategoryConfig> categoryConfigs;
    private List<NewsletterSubscriptionConfig> subscriptionConfigs;
    private NewsletterManagerService newsletterManagerService;
    private LivePortalManagerService livePortalManagerService;
    private static Log log = ExoLogger.getLogger(InitialNewsletterPlugin.class);

    public InitialNewsletterPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService, NewsletterManagerService newsletterManagerService, LivePortalManagerService livePortalManagerService) {
        super(initParams, configurationManager, repositoryService);
        this.categoryConfigs = initParams.getObjectParamValues(NewsletterCategoryConfig.class);
        this.subscriptionConfigs = initParams.getObjectParamValues(NewsletterSubscriptionConfig.class);
        this.livePortalManagerService = livePortalManagerService;
        this.newsletterManagerService = newsletterManagerService;
    }

    public void deployToPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        block5: {
            try {
                NewsletterCategoryHandler categoryHandler = this.newsletterManagerService.getCategoryHandler();
                for (NewsletterCategoryConfig categoryConfig : this.categoryConfigs) {
                    categoryHandler.add(sessionProvider, portalName, categoryConfig);
                }
                NewsletterSubscriptionHandler subscriptionHandler = this.newsletterManagerService.getSubscriptionHandler();
                for (NewsletterSubscriptionConfig subscriptionConfig : this.subscriptionConfigs) {
                    subscriptionHandler.add(sessionProvider, portalName, subscriptionConfig);
                }
                Node portalNode = this.livePortalManagerService.getLivePortal(sessionProvider, portalName);
                String userFolderPath = NewsletterConstant.generateUserPath(portalName);
                ExtendedNode userFolderNode = (ExtendedNode)((Node)portalNode.getSession().getItem(userFolderPath));
                if (userFolderNode.canAddMixin("exo:privilegeable")) {
                    userFolderNode.addMixin("exo:privilegeable");
                }
                userFolderNode.setPermission("any", PermissionType.ALL);
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block5;
                log.info((Object)"InitialNewsletterPlugin fail because of ", (Throwable)e);
            }
        }
    }
}

