/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.NamingPolicy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.gatein.mop.core.api.Attribute;
import org.gatein.mop.core.api.BooleanAttribute;
import org.gatein.mop.core.api.DateAttribute;
import org.gatein.mop.core.api.IntegerAttribute;
import org.gatein.mop.core.api.StringAttribute;
import org.gatein.mop.core.util.AbstractAttributes;

@PrimaryType(name="mop:attributes")
@NamingPrefix(value="mop")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPolicy(onDuplicate=NameConflictResolution.REPLACE)
public abstract class AttributesImpl
extends AbstractAttributes {
    @OneToMany
    public abstract Map<String, Attribute> getChildren();

    @Create
    public abstract IntegerAttribute createInteger();

    @Create
    public abstract BooleanAttribute createBoolean();

    @Create
    public abstract DateAttribute createDate();

    @Create
    public abstract StringAttribute createString();

    @Override
    protected Object get(String name) {
        Map<String, Attribute> children = this.getChildren();
        Attribute child = children.get(name);
        return child != null ? child.getValue() : null;
    }

    @Override
    protected void set(String name, Object o) {
        Map<String, Attribute> children = this.getChildren();
        if (o != null) {
            if (o instanceof Integer) {
                IntegerAttribute i = this.createInteger();
                children.put(name, i);
                i.setValue((Integer)o);
            } else if (o instanceof Boolean) {
                BooleanAttribute b = this.createBoolean();
                children.put(name, b);
                b.setValue((Boolean)o);
            } else if (o instanceof Date) {
                DateAttribute d = this.createDate();
                children.put(name, d);
                d.setValue((Date)o);
            } else {
                StringAttribute s = this.createString();
                children.put(name, s);
                s.setValue((String)o);
            }
        } else {
            children.remove(name);
        }
    }

    public Set<String> getKeys() {
        Map<String, Attribute> children = this.getChildren();
        return children.keySet();
    }
}

