/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverterImpl
implements TypeConverter {
    private static final long serialVersionUID = 1L;
    protected static final Long LONG_ZERO = 0L;
    protected static final Map<Class<?>, Class<?>> WRAPPER_TYPES;

    protected Boolean coerceToBoolean(Object value) {
        if (value == null || "".equals(value)) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value.getClass(), Boolean.class));
    }

    protected Character coerceToCharacter(Object value) {
        if (value == null || "".equals(value)) {
            return Character.valueOf('\u0000');
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof Number) {
            return Character.valueOf((char)((Number)value).shortValue());
        }
        if (value instanceof String) {
            return Character.valueOf(((String)value).charAt(0));
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value.getClass(), Character.class));
    }

    protected Number coerceStringToNumber(String value, Class<? extends Number> type) {
        try {
            if (type == BigDecimal.class) {
                return new BigDecimal(value);
            }
            if (type == BigInteger.class) {
                return new BigInteger(value);
            }
            if (type == Byte.class) {
                return Byte.valueOf(value);
            }
            if (type == Short.class) {
                return Short.valueOf(value);
            }
            if (type == Integer.class) {
                return Integer.valueOf(value);
            }
            if (type == Long.class) {
                return Long.valueOf(value);
            }
            if (type == Float.class) {
                return Float.valueOf(value);
            }
            if (type == Double.class) {
                return Double.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            throw new ELException(LocalMessages.get("error.coerce.value", value, type));
        }
        throw new ELException(LocalMessages.get("error.coerce.type", String.class, type));
    }

    protected Number coerceNumberToNumber(Number value, Class<? extends Number> type) {
        if (type.isInstance(value)) {
            return value;
        }
        if (type == BigInteger.class) {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            return BigInteger.valueOf(value.longValue());
        }
        if (type == BigDecimal.class) {
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            return new BigDecimal(value.doubleValue());
        }
        if (type == Byte.class) {
            return value.byteValue();
        }
        if (type == Short.class) {
            return value.shortValue();
        }
        if (type == Integer.class) {
            return value.intValue();
        }
        if (type == Long.class) {
            return value.longValue();
        }
        if (type == Float.class) {
            return Float.valueOf(value.floatValue());
        }
        if (type == Double.class) {
            return value.doubleValue();
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value.getClass(), type));
    }

    protected <T extends Number> T coerceToNumber(Object value, Class<T> type) {
        if (value == null || "".equals(value)) {
            return (T)this.coerceNumberToNumber(LONG_ZERO, type);
        }
        if (value instanceof Character) {
            return (T)this.coerceNumberToNumber((short)((Character)value).charValue(), type);
        }
        if (value instanceof Number) {
            return (T)this.coerceNumberToNumber((Number)value, type);
        }
        if (value instanceof String) {
            return (T)this.coerceStringToNumber((String)value, type);
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value.getClass(), type));
    }

    protected String coerceToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value.toString();
    }

    protected <T extends Enum<T>> T coerceToEnum(Object value, Class<T> type) {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(type, (String)value);
            }
            catch (IllegalArgumentException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, type));
            }
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value.getClass(), type));
    }

    protected Object coerceStringToType(String value, Class<?> type) {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor == null) {
            if ("".equals(value)) {
                return null;
            }
            throw new ELException(LocalMessages.get("error.coerce.type", String.class, type));
        }
        if ("".equals(value)) {
            try {
                editor.setAsText(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        try {
            editor.setAsText(value);
        }
        catch (IllegalArgumentException e) {
            throw new ELException(LocalMessages.get("error.coerce.value", value, type));
        }
        return editor.getValue();
    }

    protected Object coerceToType(Object value, Class<?> type) {
        if (type == String.class) {
            return this.coerceToString(value);
        }
        if (type.isPrimitive()) {
            type = WRAPPER_TYPES.get(type);
        }
        if (Number.class.isAssignableFrom(type)) {
            return this.coerceToNumber(value, type);
        }
        if (type == Character.class) {
            return this.coerceToCharacter(value);
        }
        if (type == Boolean.class) {
            return this.coerceToBoolean(value);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return this.coerceToEnum(value, type);
        }
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return value;
        }
        if (value instanceof String) {
            return this.coerceStringToType((String)value, type);
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value.getClass(), type));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public <T> T convert(Object value, Class<T> type) throws ELException {
        return (T)this.coerceToType(value, type);
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> wrapperTypes = new HashMap<Class<Comparable<Boolean>>, Class>();
        wrapperTypes.put(Boolean.TYPE, Boolean.class);
        wrapperTypes.put(Character.TYPE, Character.class);
        wrapperTypes.put(Byte.TYPE, Byte.class);
        wrapperTypes.put(Short.TYPE, Short.class);
        wrapperTypes.put(Integer.TYPE, Integer.class);
        wrapperTypes.put(Long.TYPE, Long.class);
        wrapperTypes.put(Float.TYPE, Float.class);
        wrapperTypes.put(Double.TYPE, Double.class);
        WRAPPER_TYPES = Collections.unmodifiableMap(wrapperTypes);
    }
}

