/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.tomcat;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainerVisitor;
import org.gatein.wci.WebApp;
import org.gatein.wci.authentication.GenericAuthentication;
import org.gatein.wci.command.CommandDispatcher;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;
import org.gatein.wci.tomcat.TC6WebAppContext;

public class TC6ServletContainerContext
implements ServletContainerContext,
ContainerListener,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(TC6ServletContainerContext.class);
    private final CommandDispatcher dispatcher = new CommandDispatcher("/tomcatgateinservlet");
    private final Set<String> monitoredHosts = new HashSet<String>();
    private final Set<String> monitoredContexts = new HashSet<String>();
    private final Engine engine;
    private ServletContainerContext.Registration registration;
    private boolean crossContextLogout = true;
    private GenericAuthentication authentication = new GenericAuthentication();

    public TC6ServletContainerContext(Engine engine) {
        this.engine = engine;
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        return this.dispatcher.include(targetServletContext, request, response, callback, handback);
    }

    public void setCallback(ServletContainerContext.Registration registration) {
        this.registration = registration;
    }

    public void unsetCallback(ServletContainerContext.Registration registration) {
        this.registration = null;
    }

    public void setCrossContextLogout(boolean val) {
        this.crossContextLogout = val;
    }

    public void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials, long validityMillis) throws IOException {
        this.authentication.login(credentials, request, response, validityMillis);
    }

    public void login(HttpServletRequest request, HttpServletResponse response, Credentials credentials, long validityMillis, String initialURI) throws IOException {
        this.authentication.login(credentials, request, response, validityMillis, initialURI);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            return;
        }
        sess.invalidate();
        if (!this.crossContextLogout) {
            return;
        }
        final String sessId = sess.getId();
        DefaultServletContainerFactory.getInstance().getServletContainer().visit(new ServletContainerVisitor(){

            public void accept(WebApp webApp) {
                webApp.invalidateSession(sessId);
            }
        });
    }

    public String getContainerInfo() {
        return "Tomcat/6.x";
    }

    public synchronized void containerEvent(ContainerEvent event) {
        if (event.getData() instanceof Host) {
            Host host = (Host)event.getData();
            if ("addChild".equals(event.getType())) {
                this.registerHost(host);
            } else if ("removeChild".equals(event.getType())) {
                this.unregisterHost(host);
            }
        } else if (event.getData() instanceof StandardContext) {
            StandardContext context = (StandardContext)event.getData();
            if ("addChild".equals(event.getType())) {
                this.registerContext(context);
            } else if ("removeChild".equals(event.getType())) {
                this.unregisterContext(context);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getSource() instanceof Context) {
            Context context = (Context)event.getSource();
            if ("after_start".equals(event.getType())) {
                this.start(context);
            } else if ("before_stop".equals(event.getType())) {
                this.stop(context);
            }
        }
    }

    void start() {
        Container[] childrenContainers;
        DefaultServletContainerFactory.registerContext((ServletContainerContext)this);
        for (Container childContainer : childrenContainers = this.engine.findChildren()) {
            if (!(childContainer instanceof Host)) continue;
            Host host = (Host)childContainer;
            this.registerHost(host);
        }
        this.engine.addContainerListener((ContainerListener)this);
    }

    void stop() {
        Container[] childrenContainers;
        this.engine.removeContainerListener((ContainerListener)this);
        for (Container childContainer : childrenContainers = this.engine.findChildren()) {
            if (!(childContainer instanceof Host)) continue;
            Host host = (Host)childContainer;
            this.unregisterHost(host);
        }
        this.registration.cancel();
        this.registration = null;
    }

    private void registerHost(Host host) {
        if (!this.monitoredHosts.contains(host.getName())) {
            Container[] childrenContainers;
            for (Container childContainer : childrenContainers = host.findChildren()) {
                if (!(childContainer instanceof StandardContext)) continue;
                StandardContext context = (StandardContext)childContainer;
                this.registerContext(context);
            }
            host.addContainerListener((ContainerListener)this);
            this.monitoredHosts.add(host.getName());
        }
    }

    private void unregisterHost(Host host) {
        if (this.monitoredHosts.contains(host.getName())) {
            Container[] childrenContainers;
            this.monitoredHosts.remove(host.getName());
            host.removeContainerListener((ContainerListener)this);
            for (Container childContainer : childrenContainers = host.findChildren()) {
                if (!(childContainer instanceof StandardContext)) continue;
                StandardContext context = (StandardContext)childContainer;
                this.unregisterContext(context);
            }
        }
    }

    private void registerContext(StandardContext context) {
        if (!this.monitoredContexts.contains(context.getName())) {
            context.addLifecycleListener((LifecycleListener)this);
            if (context.getState() == 1) {
                this.start((Context)context);
            }
            this.monitoredContexts.add(context.getName());
        }
    }

    private void unregisterContext(StandardContext context) {
        if (this.monitoredContexts.contains(context.getName())) {
            this.monitoredContexts.remove(context.getName());
            if (context.getState() == 1) {
                this.stop((Context)context);
            }
            context.removeLifecycleListener((LifecycleListener)this);
        }
    }

    private void start(Context context) {
        try {
            log.debug((Object)("Context added " + context.getPath()));
            TC6WebAppContext webAppContext = new TC6WebAppContext(context);
            if (this.registration != null) {
                this.registration.registerWebApp((WebAppContext)webAppContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stop(Context context) {
        try {
            if (this.registration != null) {
                this.registration.unregisterWebApp(context.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

