/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.poi.hslf.record.PositionDependentRecordAtom;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogger;

public final class PersistPtrHolder
extends PositionDependentRecordAtom {
    private byte[] _header;
    private byte[] _ptrData;
    private long _type;
    private Hashtable _slideLocations;
    private Hashtable _slideOffsetDataLocation;

    public int[] getKnownSlideIDs() {
        int[] ids = new int[this._slideLocations.size()];
        Enumeration e = this._slideLocations.keys();
        for (int i = 0; i < ids.length; ++i) {
            Integer id = (Integer)e.nextElement();
            ids[i] = id;
        }
        return ids;
    }

    public Hashtable getSlideLocationsLookup() {
        return this._slideLocations;
    }

    public Hashtable getSlideOffsetDataLocationsLookup() {
        return this._slideOffsetDataLocation;
    }

    public void addSlideLookup(int slideID, int posOnDisk) {
        byte[] newPtrData = new byte[this._ptrData.length + 8];
        System.arraycopy(this._ptrData, 0, newPtrData, 0, this._ptrData.length);
        this._slideLocations.put(slideID, posOnDisk);
        this._slideOffsetDataLocation.put(slideID, this._ptrData.length + 4);
        int infoBlock = slideID;
        LittleEndian.putInt((byte[])newPtrData, (int)(newPtrData.length - 8), (int)(infoBlock += 0x100000));
        LittleEndian.putInt((byte[])newPtrData, (int)(newPtrData.length - 4), (int)posOnDisk);
        this._ptrData = newPtrData;
        LittleEndian.putInt((byte[])this._header, (int)4, (int)newPtrData.length);
    }

    protected PersistPtrHolder(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._type = LittleEndian.getUShort((byte[])this._header, (int)2);
        this._slideLocations = new Hashtable();
        this._slideOffsetDataLocation = new Hashtable();
        this._ptrData = new byte[len - 8];
        System.arraycopy(source, start + 8, this._ptrData, 0, this._ptrData.length);
        int pos = 0;
        while (pos < this._ptrData.length) {
            long info = LittleEndian.getUInt((byte[])this._ptrData, (int)pos);
            int offset_count = (int)(info >> 20);
            int offset_no = (int)(info - (long)(offset_count << 20));
            pos += 4;
            for (int i = 0; i < offset_count; ++i) {
                int sheet_no = offset_no + i;
                long sheet_offset = LittleEndian.getUInt((byte[])this._ptrData, (int)pos);
                this._slideLocations.put(sheet_no, (int)sheet_offset);
                this._slideOffsetDataLocation.put(sheet_no, pos);
                pos += 4;
            }
        }
    }

    public long getRecordType() {
        return this._type;
    }

    public void updateOtherRecordReferences(Hashtable oldToNewReferencesLookup) {
        int[] slideIDs = this.getKnownSlideIDs();
        for (int i = 0; i < slideIDs.length; ++i) {
            Integer id = slideIDs[i];
            Integer oldPos = (Integer)this._slideLocations.get(id);
            Integer newPos = (Integer)oldToNewReferencesLookup.get(oldPos);
            if (newPos == null) {
                this.logger.log(POILogger.WARN, (Object)("Couldn't find the new location of the \"slide\" with id " + id + " that used to be at " + oldPos));
                this.logger.log(POILogger.WARN, (Object)"Not updating the position of it, you probably won't be able to find it any more (if you ever could!)");
                newPos = oldPos;
            }
            Integer dataOffset = (Integer)this._slideOffsetDataLocation.get(id);
            LittleEndian.putInt((byte[])this._ptrData, (int)dataOffset, (int)newPos);
            this._slideLocations.remove(id);
            this._slideLocations.put(id, newPos);
        }
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._ptrData);
    }
}

