/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.NotSerializableException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;

public class RpcDispatcherExceptionTest
extends ChannelTestBase {
    RpcDispatcher disp;
    Channel channel;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.channel = this.createChannel("A");
        this.disp = new RpcDispatcher(this.channel, null, null, (Object)this);
        this.channel.connect("demo");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.disp.stop();
        this.channel.close();
    }

    public void foo(Pojo p) {
        System.out.println(p.toString());
    }

    public void testUnserializableValue() {
        try {
            this.disp.callRemoteMethods(null, "foo", new Object[]{new Pojo()}, new Class[]{Pojo.class}, 2, 5000L);
            RpcDispatcherExceptionTest.fail((String)"this should have thrown an exception");
        }
        catch (Throwable t) {
            System.out.println("received an exception as expected: " + t);
            RpcDispatcherExceptionTest.assertTrue((boolean)(t instanceof RuntimeException));
            Throwable cause = t.getCause();
            RpcDispatcherExceptionTest.assertTrue((boolean)(cause instanceof NotSerializableException));
        }
    }

    public void testUnserializableValue2() {
        try {
            this.disp.callRemoteMethod(this.channel.getLocalAddress(), "foo", new Object[]{new Pojo()}, new Class[]{Pojo.class}, 2, 5000L);
            RpcDispatcherExceptionTest.fail((String)"this should have thrown an exception");
        }
        catch (Throwable t) {
            System.out.println("received an exception as expected: " + t);
            RpcDispatcherExceptionTest.assertTrue((boolean)(t instanceof NotSerializableException));
        }
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherExceptionTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherExceptionTest.suite());
    }

    static class Pojo {
        int age;
        String name;

        Pojo() {
        }
    }
}

