/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.core.value.ExtendedValue;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.AuditPropertyImpl;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.PermissionValue;
import org.exoplatform.services.jcr.impl.core.value.ValueConstraintsMatcher;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemImpl
implements Item {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemImpl");
    protected final SessionImpl session;
    protected ItemData data;
    protected JCRPath location;
    protected QPath qpath;
    protected SessionDataManager dataManager;
    protected LocationFactory locationFactory;
    protected ValueFactoryImpl valueFactory;

    ItemImpl(ItemData data, SessionImpl session) throws RepositoryException {
        this.session = session;
        this.data = data;
        this.dataManager = session.getTransientNodesManager();
        this.locationFactory = session.getLocationFactory();
        this.valueFactory = session.getValueFactory();
    }

    protected void invalidate() {
        this.data = null;
    }

    public boolean isValid() {
        return this.data != null;
    }

    protected boolean checkValid() throws InvalidItemStateException {
        try {
            this.session.checkLive();
        }
        catch (RepositoryException e) {
            throw new InvalidItemStateException("This kind of operation is forbidden after a session.logout().", (Throwable)e);
        }
        if (this.data == null) {
            throw new InvalidItemStateException("Invalid item state. Item was removed or discarded.");
        }
        this.session.updateLastAccessTime();
        return true;
    }

    public String getPath() throws RepositoryException {
        return this.getLocation().getAsString(false);
    }

    public String getName() throws RepositoryException {
        return this.getLocation().getName().getAsString();
    }

    public Item getAncestor(int degree) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.checkValid();
        try {
            if (degree < 0) {
                throw new ItemNotFoundException("Can't get ancestor with ancestor's degree < 0.");
            }
            QPath myPath = this.getData().getQPath();
            int n = myPath.getDepth() - degree;
            if (n == 0) {
                return this;
            }
            if (n < 0) {
                throw new ItemNotFoundException("Can't get ancestor with ancestor's degree > depth of this item.");
            }
            QPath ancestorPath = myPath.makeAncestorPath(n);
            return this.dataManager.getItem(ancestorPath, true);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public NodeImpl getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.checkValid();
        if (this.isRoot()) {
            throw new ItemNotFoundException("Root node does not have a parent");
        }
        return this.parent(true);
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public int getDepth() {
        return this.qpath.getDepth();
    }

    public boolean isSame(Item otherItem) {
        if (this.isValid()) {
            if (otherItem == null) {
                return false;
            }
            if (!this.getClass().equals(otherItem.getClass())) {
                return false;
            }
            try {
                return this.getInternalIdentifier().equals(((ItemImpl)otherItem).getInternalIdentifier());
            }
            catch (Exception e) {
                LOG.debug((Object)("Item.isSame() failed " + e.getMessage()));
                return false;
            }
        }
        return false;
    }

    public boolean isNew() {
        if (this.isValid()) {
            return this.dataManager.isNew(this.getInternalIdentifier());
        }
        return false;
    }

    public boolean isModified() {
        if (this.isValid()) {
            return this.dataManager.isModified(this.getData());
        }
        return true;
    }

    public void remove() throws RepositoryException, ConstraintViolationException, VersionException, LockException {
        this.checkValid();
        if (this.isRoot()) {
            throw new RepositoryException("Can't remove ROOT node.");
        }
        Object def = this.isNode() ? ((NodeImpl)this).getDefinition() : ((PropertyImpl)this).getDefinition();
        if (def.isMandatory() || def.isProtected()) {
            throw new ConstraintViolationException("Can't remove mandatory or protected item " + this.getPath());
        }
        NodeImpl parentNode = this.parent();
        if (!parentNode.checkedOut()) {
            throw new VersionException("Node " + this.parent().getPath() + " or its nearest ancestor is checked-in");
        }
        if (!parentNode.checkLocking()) {
            throw new LockException("Node " + this.parent().getPath() + " is locked ");
        }
        this.session.getActionHandler().preRemoveItem(this);
        this.removeVersionable();
        this.dataManager.delete(this.data);
    }

    protected void removeVersionable() throws RepositoryException, ConstraintViolationException, VersionException {
        NodeData node;
        NodeTypeDataManager ntManager;
        if (this.isNode() && (ntManager = this.session.getWorkspace().getNodeTypesHolder()).isNodeType(Constants.MIX_VERSIONABLE, (node = (NodeData)this.data).getPrimaryTypeName(), node.getMixinTypeNames())) {
            ItemData vhpd = this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_VERSIONHISTORY, 1), ItemType.PROPERTY);
            if (vhpd != null && !vhpd.isNode()) {
                try {
                    String vhID = new String(((PropertyData)vhpd).getValues().get(0).getAsByteArray());
                    this.dataManager.removeVersionHistory(vhID, null, this.data.getQPath());
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            } else {
                throw new RepositoryException("Version history not found for " + node.getQPath().getAsString());
            }
        }
    }

    protected PropertyImpl doUpdateProperty(NodeImpl parentNode, InternalQName propertyName, Value propertyValue, boolean multiValue, int expectedType) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] val = null;
        if (propertyValue != null) {
            val = new Value[]{propertyValue};
        }
        return this.doUpdateProperty(parentNode, propertyName, val, multiValue, expectedType);
    }

    protected PropertyImpl doUpdateProperty(NodeImpl parentNode, InternalQName propertyName, Value[] propertyValues, boolean multiValue, int expectedType) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        PropertyImpl prop;
        int requiredType;
        int state;
        PropertyImpl prevProp;
        PropertyDefinitionDatas defs;
        int version;
        String identifier;
        if (!parentNode.checkedOut()) {
            throw new VersionException("Node " + parentNode.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!parentNode.checkLocking()) {
            throw new LockException("Node " + parentNode.getPath() + " is locked ");
        }
        QPath qpath = QPath.makeChildPath(parentNode.getInternalPath(), propertyName);
        ItemImpl prevItem = this.dataManager.getItem(parentNode.nodeData(), new QPathEntry(propertyName, 0), true, this.dataManager.isNew(parentNode.getIdentifier()), ItemType.PROPERTY, false);
        NodeTypeDataManager ntm = this.session.getWorkspace().getNodeTypesHolder();
        NodeData parentData = (NodeData)parentNode.getData();
        boolean isMultiValue = multiValue;
        AuditPropertyImpl prevProperty = null;
        if (prevItem == null || prevItem.isNode()) {
            identifier = IdGenerator.generate();
            version = -1;
            if (propertyValues == null) {
                TransientPropertyData nullData = new TransientPropertyData(qpath, identifier, version, 0, parentNode.getInternalIdentifier(), isMultiValue);
                PropertyImpl nullProperty = new PropertyImpl(nullData, this.session);
                nullProperty.invalidate();
                return nullProperty;
            }
            defs = ntm.getPropertyDefinitions(propertyName, parentData.getPrimaryTypeName(), parentData.getMixinTypeNames());
            prevProp = null;
            state = 1;
        } else {
            prevProp = (PropertyImpl)prevItem;
            prevProperty = new AuditPropertyImpl(prevProp.getData(), prevProp.getSession());
            isMultiValue = prevProp.isMultiValued();
            defs = ntm.getPropertyDefinitions(propertyName, parentData.getPrimaryTypeName(), parentData.getMixinTypeNames());
            identifier = prevProp.getInternalIdentifier();
            version = prevProp.getData().getPersistedVersion();
            state = propertyValues == null ? 4 : 2;
        }
        if (defs == null || defs.getAnyDefinition() == null) {
            throw new ConstraintViolationException("Property definition '" + propertyName.getAsString() + "' is not found.");
        }
        PropertyDefinitionData def = defs.getDefinition(isMultiValue);
        if (def != null && def.isProtected()) {
            throw new ConstraintViolationException("Can not set protected property " + this.locationFactory.createJCRPath(qpath).getAsString(false));
        }
        if (multiValue && (def == null || prevProp != null && !prevProp.isMultiValued())) {
            throw new ValueFormatException("Can not assign multiple-values Value to a single-valued property " + this.locationFactory.createJCRPath(qpath).getAsString(false));
        }
        if (!multiValue && (def == null || prevProp != null && prevProp.isMultiValued())) {
            throw new ValueFormatException("Can not assign single-value Value to a multiple-valued property " + this.locationFactory.createJCRPath(qpath).getAsString(false));
        }
        ArrayList<ValueData> valueDataList = new ArrayList<ValueData>();
        int propType = requiredType = def.getRequiredType();
        if (propertyValues != null) {
            if (propertyValues.length > 1 && propertyValues[0] != null) {
                int vType = propertyValues[0].getType();
                for (Value val : propertyValues) {
                    if (val == null || vType == val.getType()) continue;
                    throw new ValueFormatException("All Value objects in the array must be of the same type");
                }
            }
            if (propertyValues.length > 0 && requiredType == 0) {
                if (expectedType == 0) {
                    Value[] arr$ = propertyValues;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Value val = arr$[i$];
                        if (val == null) continue;
                        expectedType = val.getType();
                        break;
                    }
                }
                propType = expectedType;
            }
            for (Value value : propertyValues) {
                if (value != null) {
                    valueDataList.add(this.valueData(value, propType));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Set null value (" + this.getPath() + ", multivalued: " + multiValue + ")"));
            }
        }
        this.checkValueConstraints(def, valueDataList, propType);
        if (requiredType != 0 && expectedType != 0 && requiredType != expectedType) {
            throw new ConstraintViolationException(" the type parameter " + ExtendedPropertyType.nameFromValue(expectedType) + " and the " + "type of the property do not match required type" + ExtendedPropertyType.nameFromValue(requiredType));
        }
        if (state != 4) {
            TransientPropertyData newData = new TransientPropertyData(qpath, identifier, version, propType, parentNode.getInternalIdentifier(), multiValue, valueDataList);
            ItemState itemState = new ItemState(newData, state, true, qpath, false);
            prop = (PropertyImpl)this.dataManager.update(itemState, true);
            this.session.getActionHandler().postSetProperty(prevProperty, prop, parentNode.nodeData(), state);
        } else {
            if (def.isMandatory()) {
                throw new ConstraintViolationException("Can not remove (by setting null value) mandatory property " + this.locationFactory.createJCRPath(qpath).getAsString(false));
            }
            TransientPropertyData newData = new TransientPropertyData(qpath, identifier, version, propType, parentNode.getInternalIdentifier(), multiValue);
            this.session.getActionHandler().preRemoveItem(prevProp);
            this.dataManager.delete(newData);
            prop = prevProp;
        }
        return prop;
    }

    public void save() throws ReferentialIntegrityException, AccessDeniedException, LockException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, RepositoryException {
        this.checkValid();
        if (this.isNew()) {
            throw new RepositoryException("It is impossible to call save() on the newly added item " + this.getPath());
        }
        NodeTypeDataManager ntManager = this.session.getWorkspace().getNodeTypesHolder();
        if (this.isNode()) {
            int i;
            QPath path = this.getInternalPath();
            List<ItemState> changes = this.dataManager.getChangesLog().getDescendantsChanges(path);
            ArrayList<NodeData> refNodes = new ArrayList<NodeData>();
            int length = changes.size();
            for (i = 0; i < length; ++i) {
                NodeData refNode;
                ItemState changedItem = changes.get(i);
                if (!changedItem.isNode() || !ntManager.isNodeType(Constants.MIX_REFERENCEABLE, (refNode = (NodeData)changedItem.getData()).getPrimaryTypeName(), refNode.getMixinTypeNames())) continue;
                if (changedItem.isDeleted()) {
                    refNodes.add(refNode);
                    continue;
                }
                if (!changedItem.isAdded() && !changedItem.isRenamed()) continue;
                refNodes.remove(refNode);
            }
            length = refNodes.size();
            for (i = 0; i < length; ++i) {
                NodeData refNode = (NodeData)refNodes.get(i);
                List<PropertyData> nodeRefs = this.dataManager.getReferencesData(refNode.getIdentifier(), true);
                int length2 = nodeRefs.size();
                for (int j = 0; j < length2; ++j) {
                    PropertyData refProp = nodeRefs.get(j);
                    ItemState refState = this.dataManager.getChangesLog().getItemState(refProp.getIdentifier());
                    if (refState != null && refState.isDeleted()) continue;
                    NodeData refParent = (NodeData)this.dataManager.getItemData(refProp.getParentIdentifier());
                    AccessControlList acl = refParent.getACL();
                    AccessManager am = this.session.getAccessManager();
                    if (!am.hasPermission(acl, "read", this.session.getUserState().getIdentity())) {
                        throw new AccessDeniedException("Can not delete node " + refNode.getQPath() + " (" + refNode.getIdentifier() + ")" + ". It is currently the target of a REFERENCE property and " + refProp.getQPath().getAsString());
                    }
                    throw new ReferentialIntegrityException("Can not delete node " + refNode.getQPath() + " (" + refNode.getIdentifier() + ")" + ". It is currently the target of a REFERENCE property " + refProp.getQPath().getAsString());
                }
            }
        }
        this.dataManager.commit(this.getInternalPath());
    }

    public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        this.checkValid();
        if (keepChanges) {
            this.dataManager.refresh(this.getData());
        } else {
            this.dataManager.rollback(this.getData());
        }
    }

    public ItemData getData() {
        return this.data;
    }

    public String getParentIdentifier() {
        return this.getData().getParentIdentifier();
    }

    public QPath getInternalPath() {
        return this.getData().getQPath();
    }

    public InternalQName getInternalName() {
        return this.getData().getQPath().getName();
    }

    protected NodeImpl parent() throws RepositoryException {
        return this.parent(false);
    }

    protected NodeImpl parent(boolean pool) throws RepositoryException {
        NodeImpl parent = (NodeImpl)this.dataManager.getItemByIdentifier(this.getParentIdentifier(), pool);
        if (parent == null) {
            throw new ItemNotFoundException("FATAL: Parent is null for " + this.getPath() + " parent UUID: " + this.getParentIdentifier());
        }
        return parent;
    }

    public NodeData parentData() throws RepositoryException {
        this.checkValid();
        NodeData parent = (NodeData)this.dataManager.getItemData(this.getData().getParentIdentifier());
        if (parent == null) {
            throw new ItemNotFoundException("FATAL: Parent is null for " + this.getPath() + " parent UUID: " + this.getData().getParentIdentifier());
        }
        return parent;
    }

    protected NodeTypeData[] nodeTypes(NodeData node) throws RepositoryException {
        InternalQName primaryTypeName = node.getPrimaryTypeName();
        InternalQName[] mixinNames = node.getMixinTypeNames();
        NodeTypeData[] nodeTypes = new NodeTypeData[mixinNames.length + 1];
        NodeTypeDataManager ntm = this.session.getWorkspace().getNodeTypesHolder();
        nodeTypes[0] = ntm.getNodeType(primaryTypeName);
        for (int i = 1; i <= mixinNames.length; ++i) {
            nodeTypes[i] = ntm.getNodeType(mixinNames[i - 1]);
        }
        return nodeTypes;
    }

    public String getInternalIdentifier() {
        return this.data.getIdentifier();
    }

    public JCRPath getLocation() throws RepositoryException {
        if (this.location == null) {
            this.location = this.session.getLocationFactory().createJCRPath(this.qpath);
        }
        return this.location;
    }

    public boolean isRoot() {
        return this.data.getIdentifier().equals("00exo0jcr0root0uuid0000000000000");
    }

    abstract void loadData(ItemData var1) throws RepositoryException;

    abstract void loadData(ItemData var1, NodeData var2) throws RepositoryException;

    abstract ItemDefinitionData getItemDefinitionData();

    public boolean hasPermission(String action) throws RepositoryException {
        this.checkValid();
        NodeData ndata = this.isNode() ? (NodeData)this.getData() : this.parentData();
        return this.session.getAccessManager().hasPermission(ndata.getACL(), action, this.session.getUserState().getIdentity());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemImpl) {
            ItemImpl otherItem = (ItemImpl)obj;
            if (!otherItem.isValid() || !this.isValid()) {
                return false;
            }
            try {
                return this.getInternalIdentifier().equals(otherItem.getInternalIdentifier());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private ValueData valueData(Value value, int type) throws RepositoryException, ValueFormatException {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 1: {
                return new TransientValueData(value.getString());
            }
            case 2: {
                ValueData vd = value instanceof BaseValue || value instanceof ExtendedValue ? ((BaseValue)this.getSession().getValueFactory().createValue(value.getStream())).getInternalData() : ((BaseValue)this.getSession().getValueFactory().createValue(value.getString(), 2)).getInternalData();
                return vd;
            }
            case 6: {
                return new TransientValueData(value.getBoolean());
            }
            case 3: {
                return new TransientValueData(value.getLong());
            }
            case 4: {
                return new TransientValueData(value.getDouble());
            }
            case 5: {
                return new TransientValueData(value.getDate());
            }
            case 8: {
                ValueData pvd;
                if (value instanceof PathValue) {
                    pvd = ((PathValue)value).getInternalData();
                } else {
                    QPath pathValue = this.locationFactory.parseJCRPath(value.getString()).getInternalPath();
                    pvd = new TransientValueData(pathValue);
                }
                return pvd;
            }
            case 7: {
                InternalQName nameValue = this.locationFactory.parseJCRName(value.getString()).getInternalName();
                return new TransientValueData(nameValue);
            }
            case 9: {
                Identifier identifier = new Identifier(value.getString());
                return new TransientValueData(identifier);
            }
            case 100: {
                PermissionValue permValue = (PermissionValue)value;
                AccessControlEntry ace = new AccessControlEntry(permValue.getIdentity(), permValue.getPermission());
                return new TransientValueData(ace);
            }
        }
        throw new ValueFormatException("ValueFactory.convert() unknown or unconvertable type " + type);
    }

    private void checkValueConstraints(PropertyDefinitionData def, List<ValueData> newValues, int type) throws RepositoryException {
        ValueConstraintsMatcher constraints = new ValueConstraintsMatcher(def.getValueConstraints(), this.session.getLocationFactory(), this.session.getTransientNodesManager(), this.session.getWorkspace().getNodeTypesHolder());
        for (ValueData value : newValues) {
            if (constraints.match(value, type)) continue;
            String strVal = null;
            try {
                strVal = type != 2 ? ValueDataConvertor.readString(value) : "PropertyType.BINARY";
            }
            catch (IOException e) {
                LOG.error((Object)("Error of value read: " + e.getMessage()), (Throwable)e);
            }
            throw new ConstraintViolationException("Can not set value '" + strVal + "' to " + this.getPath() + " due to value constraints ");
        }
    }
}

