/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;

public class ConcatProxyServlet
extends InjectedServlet {
    private static final long serialVersionUID = -4390212150673709895L;
    public static final String JSON_PARAM = UriCommon.Param.JSON.getKey();
    private static final Pattern JSON_PARAM_PATTERN = Pattern.compile("^\\w*$");
    static final Integer LONG_LIVED_REFRESH = 31536000;
    static final Integer DEFAULT_REFRESH = 3600;
    private static final Logger LOG = Logger.getLogger(ConcatProxyServlet.class.getName());
    private transient RequestPipeline requestPipeline;
    private transient ConcatUriManager concatUriManager;
    private transient ResponseRewriterRegistry contentRewriterRegistry;
    private transient ExecutorService executor = Executors.newSingleThreadExecutor();

    @Inject
    public void setRequestPipeline(RequestPipeline requestPipeline) {
        this.checkInitialized();
        this.requestPipeline = requestPipeline;
    }

    @Inject
    public void setConcatUriManager(ConcatUriManager concatUriManager) {
        this.checkInitialized();
        this.concatUriManager = concatUriManager;
    }

    @Inject
    public void setContentRewriterRegistry(ResponseRewriterRegistry contentRewriterRegistry) {
        this.checkInitialized();
        this.contentRewriterRegistry = contentRewriterRegistry;
    }

    @Inject
    public void setExecutor(@Named(value="shindig.concat.executor") ExecutorService executor) {
        this.checkInitialized();
        this.executor = executor;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getHeader("If-Modified-Since") != null) {
            response.setStatus(304);
            return;
        }
        Uri uri = new UriBuilder(request).toUri();
        ConcatUriManager.ConcatUri concatUri = this.concatUriManager.process(uri);
        ConcatUriManager.Type concatType = concatUri.getType();
        try {
            if (concatType == null) {
                throw new GadgetException(GadgetException.Code.MISSING_PARAMETER, "Missing type", 400);
            }
            HttpUtil.setCachingHeaders((HttpServletResponse)response, (int)concatUri.translateStatusRefresh(LONG_LIVED_REFRESH, DEFAULT_REFRESH), (boolean)false);
        }
        catch (GadgetException gex) {
            response.sendError(400, ConcatProxyServlet.formatError(gex, uri));
            return;
        }
        response.setHeader("Content-Type", concatType.getMimeType() + "; charset=UTF8");
        response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        if (this.doFetchConcatResources(response, concatUri)) {
            response.setStatus(200);
        } else {
            response.setStatus(400);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doFetchConcatResources(HttpServletResponse response, ConcatUriManager.ConcatUri concatUri) throws IOException {
        cos = null;
        jsonVar = concatUri.getSplitParam();
        if (jsonVar == null) ** GOTO lbl9
        if (ConcatProxyServlet.JSON_PARAM_PATTERN.matcher(jsonVar).matches()) {
            cos = new JsonConcatOutputStream(response.getOutputStream(), jsonVar);
        } else {
            response.getOutputStream().println(ConcatProxyServlet.formatHttpError(400, "Bad json variable name " + jsonVar, null));
            return false;
lbl9:
            // 1 sources

            cos = new VerbatimConcatOutputStream(response.getOutputStream());
        }
        futureTasks = new ArrayList<Pair>();
        try {
            for (Uri resourceUri : concatUri.getBatch()) {
                try {
                    httpReq = concatUri.makeHttpRequest(resourceUri);
                    httpFetcher = new FutureTask<RequestContext>(new HttpFetchCallable(httpReq));
                    futureTasks.add(Pair.of((Object)httpReq.getUri(), httpFetcher));
                    this.executor.execute(httpFetcher);
                }
                catch (GadgetException ge) {
                    if (!cos.outputError(resourceUri, ge)) continue;
                    httpFetcher = false;
                    if (cos != null) {
                        try {
                            cos.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    return httpFetcher;
                }
            }
            for (Pair futureTask : futureTasks) {
                requestCxt = null;
                try {
                    try {
                        requestCxt = (RequestContext)((FutureTask)futureTask.two).get();
                    }
                    catch (InterruptedException ie) {
                        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)ie);
                    }
                    catch (ExecutionException ee) {
                        throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)ee);
                    }
                    if (requestCxt.getGadgetException() != null) {
                        throw requestCxt.getGadgetException();
                    }
                    httpResp = requestCxt.getHttpResp();
                    if (httpResp != null) {
                        if (this.contentRewriterRegistry != null) {
                            try {
                                httpResp = this.contentRewriterRegistry.rewriteHttpResponse(requestCxt.getHttpReq(), httpResp);
                            }
                            catch (RewritingException e) {
                                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, e.getHttpStatusCode());
                            }
                        }
                    } else {
                        var10_18 = false;
                        return var10_18;
                    }
                    cos.output((Uri)futureTask.one, httpResp);
                }
                catch (GadgetException ge) {
                    if (!cos.outputError((Uri)futureTask.one, ge)) continue;
                    var10_19 = false;
                    return var10_19;
                }
            }
        }
        finally {
            if (cos != null) {
                try {
                    cos.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    private static String formatHttpError(int status, String errorMessage, Uri uri) {
        StringBuilder err = new StringBuilder();
        err.append("/* ---- Error ");
        err.append(status);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            err.append(", ");
            err.append(errorMessage);
        }
        if (uri != null) {
            err.append(" (").append(uri.toString()).append(')');
        }
        err.append(" ---- */");
        return err.toString();
    }

    private static String formatError(GadgetException excep, Uri uri) throws IOException {
        StringBuilder err = new StringBuilder();
        err.append(excep.getCode().toString());
        err.append(" concat(");
        err.append(uri.toString());
        err.append(") ");
        err.append(excep.getMessage());
        LOG.log(Level.INFO, "Concat proxy request failed", err);
        return err.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HttpFetchCallable
    implements Callable<RequestContext> {
        private HttpRequest httpReq;

        public HttpFetchCallable(HttpRequest httpReq) {
            this.httpReq = httpReq;
        }

        @Override
        public RequestContext call() {
            HttpResponse httpResp = null;
            GadgetException gEx = null;
            try {
                httpResp = ConcatProxyServlet.this.requestPipeline.execute(this.httpReq);
            }
            catch (GadgetException ge) {
                gEx = ge;
            }
            return new RequestContext(this.httpReq, httpResp, gEx);
        }
    }

    private static class RequestContext {
        private HttpRequest httpReq;
        private HttpResponse httpResp;
        private GadgetException gadgetException;

        public HttpRequest getHttpReq() {
            return this.httpReq;
        }

        public HttpResponse getHttpResp() {
            return this.httpResp;
        }

        public GadgetException getGadgetException() {
            return this.gadgetException;
        }

        public RequestContext(HttpRequest httpReq, HttpResponse httpResp, GadgetException ge) {
            this.httpReq = httpReq;
            this.httpResp = httpResp;
            this.gadgetException = ge;
        }
    }

    private static class JsonConcatOutputStream
    extends ConcatOutputStream {
        public JsonConcatOutputStream(ServletOutputStream wrapped, String tok) throws IOException {
            super(wrapped);
            this.println(tok + "={");
        }

        protected void outputJs(Uri uri, String data) throws IOException {
            this.print("\"");
            this.print(uri.toString());
            this.print("\":\"");
            this.print(StringEscapeUtils.escapeJavaScript((String)data));
            this.println("\",");
        }

        public void close() throws IOException {
            this.println("};");
            super.close();
        }
    }

    private static class VerbatimConcatOutputStream
    extends ConcatOutputStream {
        public VerbatimConcatOutputStream(ServletOutputStream wrapped) {
            super(wrapped);
        }

        protected void outputJs(Uri uri, String data) throws IOException {
            this.println("/* ---- Start " + uri.toString() + " ---- */");
            this.print(data);
            this.println("/* ---- End " + uri.toString() + " ---- */");
        }
    }

    private static abstract class ConcatOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream wrapped;

        protected ConcatOutputStream(ServletOutputStream wrapped) {
            this.wrapped = wrapped;
        }

        protected abstract void outputJs(Uri var1, String var2) throws IOException;

        public void output(Uri uri, HttpResponse resp) throws IOException {
            if (resp.getHttpStatusCode() != 200) {
                this.println(ConcatProxyServlet.formatHttpError(resp.getHttpStatusCode(), resp.getResponseAsString(), uri));
            } else {
                this.outputJs(uri, resp.getResponseAsString());
            }
        }

        public boolean outputError(Uri uri, GadgetException e) throws IOException {
            this.print(ConcatProxyServlet.formatError(e, uri));
            return e.getHttpStatusCode() == 500;
        }

        public void write(int b) throws IOException {
            this.wrapped.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.wrapped.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.wrapped.write(b);
        }

        public void close() throws IOException {
            this.wrapped.close();
        }

        public void print(String data) throws IOException {
            this.write(data.getBytes("UTF8"));
        }

        public void println(String data) throws IOException {
            this.print(data);
            this.write("\r\n".getBytes("UTF8"));
        }
    }
}

