/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserEventListenerHandler;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.ByGroupLdapUserListAccess;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.SimpleLdapUserListAccess;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDAOImpl
extends BaseDAO
implements UserHandler,
UserEventListenerHandler {
    private List<UserEventListener> listeners = new ArrayList<UserEventListener>(5);
    private OrganizationService os;

    public UserDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, CacheHandler cacheHandler) throws Exception {
        super(ldapAttrMapping, ldapService, cacheHandler);
    }

    public UserDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, CacheHandler cacheHandler, OrganizationService os) throws Exception {
        this(ldapAttrMapping, ldapService, cacheHandler);
        this.os = os;
    }

    public void addUserEventListener(UserEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    public void removeUserEventListener(UserEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(User user, boolean broadcast) throws Exception {
        String dnKeyValue = this.getDNKeyValue(user);
        String userDN = this.ldapAttrMapping.userDNKey + "=" + dnKeyValue + "," + this.ldapAttrMapping.userURL;
        Attributes attrs = this.ldapAttrMapping.userToAttributes(user);
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    if (broadcast) {
                        this.preSave(user, true);
                    }
                    ctx.createSubcontext(userDN, attrs);
                    if (broadcast) {
                        this.postSave(user, true);
                    }
                    this.cacheHandler.put((Serializable)((Object)user.getUserName()), (Object)user, CacheHandler.CacheType.USER);
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUser(User user, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        String userDN = null;
        User existingUser = null;
        try {
            int err = 0;
            while (true) {
                block11: {
                    try {
                        userDN = this.getDNFromUsername(ctx, user.getUserName());
                        if (userDN != null) break block11;
                        return;
                    }
                    catch (NamingException e) {
                        ctx = this.reloadCtx(ctx, err, e);
                        ++err;
                        continue;
                    }
                }
                existingUser = this.getUserFromUsername(ctx, user.getUserName());
                ModificationItem[] mods = this.createUserModification(user, existingUser);
                if (broadcast) {
                    this.preSave(user, false);
                }
                ctx.modifyAttributes(userDN, mods);
                if (broadcast) {
                    this.postSave(user, false);
                }
                this.cacheHandler.put((Serializable)((Object)user.getUserName()), (Object)user, CacheHandler.CacheType.USER);
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
        if (existingUser != null && !user.getPassword().equals(existingUser.getPassword())) {
            this.saveUserPassword(user, userDN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveUserPassword(User user, String userDN) throws Exception {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.userPassword, user.getPassword()))};
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    ctx.modifyAttributes(userDN, mods);
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                User user;
                block11: {
                    try {
                        user = this.getUserFromUsername(ctx, userName);
                        if (user != null) break block11;
                        User user2 = null;
                        return user2;
                    }
                    catch (NamingException e) {
                        ctx = this.reloadCtx(ctx, err, e);
                        ++err;
                        continue;
                    }
                }
                String userDN = this.getDNFromUsername(ctx, userName);
                if (broadcast) {
                    this.preDelete(user);
                }
                ctx.destroySubcontext(userDN);
                if (this.os != null) {
                    this.os.getUserProfileHandler().removeUserProfile(userName, broadcast);
                }
                this.cacheHandler.remove((Serializable)((Object)userName), CacheHandler.CacheType.USER);
                this.cacheHandler.remove((Serializable)((Object)("u=" + userName)), CacheHandler.CacheType.MEMBERSHIP);
                if (broadcast) {
                    this.postDelete(user);
                }
                User user3 = user;
                return user3;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public User findUserByName(String userName) throws Exception {
        User user = (User)this.cacheHandler.get((Serializable)((Object)userName), CacheHandler.CacheType.USER);
        if (user != null) {
            return user;
        }
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    user = this.getUserFromUsername(ctx, userName);
                    if (user != null) {
                        this.cacheHandler.put((Serializable)((Object)user.getUserName()), (Object)user, CacheHandler.CacheType.USER);
                    }
                    User user2 = user;
                    return user2;
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public LazyPageList<User> findUsersByGroup(String groupId) throws Exception {
        return new LazyPageList(this.findUsersByGroupId(groupId), 10);
    }

    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        String searchBase = this.getGroupDNFromGroupId(groupId);
        String filter = this.ldapAttrMapping.membershipObjectClassFilter;
        return new ByGroupLdapUserListAccess(this.ldapAttrMapping, this.ldapService, searchBase, filter);
    }

    public LazyPageList<User> getUserPageList(int pageSize) throws Exception {
        return new LazyPageList(this.findAllUsers(), 10);
    }

    public ListAccess<User> findAllUsers() throws Exception {
        String searchBase = this.ldapAttrMapping.userURL;
        String filter = this.ldapAttrMapping.userObjectClassFilter;
        return new SimpleLdapUserListAccess(this.ldapAttrMapping, this.ldapService, searchBase, filter);
    }

    public LazyPageList<User> findUsers(Query q) throws Exception {
        return new LazyPageList(this.findUsersByQuery(q), 10);
    }

    public ListAccess<User> findUsersByQuery(Query q) throws Exception {
        String filter = null;
        ArrayList<String> list = new ArrayList<String>();
        if (q.getUserName() != null && q.getUserName().length() > 0) {
            list.add("(" + this.ldapAttrMapping.userUsernameAttr + "=" + this.addAsterisks(q.getUserName()) + ")");
        }
        if (q.getFirstName() != null && q.getFirstName().length() > 0) {
            list.add("(" + this.ldapAttrMapping.userFirstNameAttr + "=" + q.getFirstName() + ")");
        }
        if (q.getLastName() != null && q.getLastName().length() > 0) {
            list.add("(" + this.ldapAttrMapping.userLastNameAttr + "=" + q.getLastName() + ")");
        }
        if (q.getEmail() != null && q.getEmail().length() > 0) {
            list.add("(" + this.ldapAttrMapping.userMailAttr + "=" + q.getEmail() + ")");
        }
        if (list.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("(&");
            for (int x = 0; x < list.size(); ++x) {
                buffer.append((String)list.get(x));
            }
            buffer.append("(" + this.ldapAttrMapping.userObjectClassFilter + "))");
            filter = buffer.toString();
        } else {
            filter = "(" + this.ldapAttrMapping.userObjectClassFilter + ")";
        }
        String searchBase = this.ldapAttrMapping.userURL;
        return new SimpleLdapUserListAccess(this.ldapAttrMapping, this.ldapService, searchBase, filter);
    }

    private String addAsterisks(String s) {
        StringBuffer sb = new StringBuffer(s);
        if (!s.startsWith("*")) {
            sb.insert(0, "*");
        }
        if (!s.endsWith("*")) {
            sb.append("*");
        }
        return sb.toString();
    }

    public boolean authenticate(String username, String password) throws Exception {
        String userDN = this.getDNFromUsername(username);
        if (userDN == null) {
            return false;
        }
        try {
            return this.ldapService.authenticate(userDN, password);
        }
        catch (NamingException exp) {
            return false;
        }
    }

    private String getDNKeyValue(User user) {
        String dnKeyValue = user.getUserName();
        if (!this.ldapAttrMapping.userDNKey.equals(this.ldapAttrMapping.userUsernameAttr)) {
            if (this.ldapAttrMapping.userDNKey.equals(this.ldapAttrMapping.userLastNameAttr)) {
                dnKeyValue = user.getLastName();
            } else if (this.ldapAttrMapping.userDNKey.equals(this.ldapAttrMapping.userFirstNameAttr)) {
                dnKeyValue = user.getFirstName();
            } else if (this.ldapAttrMapping.userDNKey.equals(this.ldapAttrMapping.userMailAttr)) {
                dnKeyValue = user.getEmail();
            } else if (this.ldapAttrMapping.userDNKey.equals(this.ldapAttrMapping.userDisplayNameAttr)) {
                dnKeyValue = user.getFullName();
            }
        }
        return dnKeyValue;
    }

    private ModificationItem[] createUserModification(User user, User existingUser) {
        ModificationItem mod;
        ArrayList<ModificationItem> modifications = new ArrayList<ModificationItem>();
        if (!user.getFullName().equals(existingUser.getFullName())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.userDisplayNameAttr, user.getFullName()));
            modifications.add(mod);
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.ldapDescriptionAttr, user.getFullName()));
            modifications.add(mod);
        }
        if (!user.getUserName().equals(existingUser.getUserName())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.userUsernameAttr, user.getUserName()));
            modifications.add(mod);
        }
        if (!user.getLastName().equals(existingUser.getLastName())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.userLastNameAttr, user.getLastName()));
            modifications.add(mod);
        }
        if (!user.getFirstName().equals(existingUser.getFirstName())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.userFirstNameAttr, user.getFirstName()));
            modifications.add(mod);
        }
        if (!user.getEmail().equals(existingUser.getEmail())) {
            mod = new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.userMailAttr, user.getEmail()));
            modifications.add(mod);
        }
        ModificationItem[] mods = new ModificationItem[modifications.size()];
        return modifications.toArray(mods);
    }

    protected void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preSave(user, isNew);
        }
    }

    protected void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postSave(user, isNew);
        }
    }

    protected void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preDelete(user);
        }
    }

    protected void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postDelete(user);
        }
    }

    public List<UserEventListener> getUserListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

