/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.lock.LockManagerImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockManagerListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger((String)LockManagerListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Removing the locks of all locked nodes");
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        ConversationState conversationState = (ConversationState)event.getData();
        String userid = conversationState.getIdentity().getUserId();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container == null) {
            RootContainer rootContainer = RootContainer.getInstance();
            container = rootContainer.getPortalContainer("portal");
        }
        CacheService cacheService = (CacheService)container.getComponentInstanceOfType(CacheService.class);
        ExoCache lockcache = cacheService.getCacheInstance(LockManagerImpl.class.getName());
        try {
            Map lockedNodes = (Map)lockcache.get((Serializable)((Object)userid));
            if (lockedNodes == null || lockedNodes.values().isEmpty()) {
                return;
            }
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            String key = null;
            String nodePath = null;
            String workspaceName = null;
            String lockToken = null;
            String[] temp = null;
            String[] location = null;
            Session session = null;
            Iterator iter = lockedNodes.keySet().iterator();
            while (iter.hasNext()) {
                try {
                    key = (String)iter.next();
                    temp = key.split(":/:");
                    nodePath = temp[1];
                    location = temp[0].split("/::/");
                    workspaceName = location[1];
                    session = sessionProvider.getSession(workspaceName, repositoryService.getCurrentRepository());
                    lockToken = (String)lockedNodes.get(key);
                    session.addLockToken(lockToken);
                    Node node = (Node)session.getItem(nodePath);
                    node.unlock();
                    node.removeMixin("mix:lockable");
                    node.save();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)"Error while unlocking the locked nodes", (Throwable)e);
                }
                finally {
                    if (session == null) continue;
                    session.logout();
                }
            }
            lockedNodes.clear();
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error during the time unlocking the locked nodes", (Throwable)ex);
            }
        }
        finally {
            sessionProvider.close();
        }
    }
}

