/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import org.imgscalr.Scalr;

public class ImageUtils {
    public static InputStream scaleImage(BufferedImage image, int maxWidth, int maxHeight) throws Exception {
        return ImageUtils.scaleImage(image, maxWidth, maxHeight, false);
    }

    public static InputStream scaleImage(BufferedImage image, int maxWidth, int maxHeight, boolean crop) throws Exception {
        BufferedImage thumbImage = null;
        thumbImage = crop ? Scalr.crop((BufferedImage)image, (int)maxWidth, (int)maxHeight, (BufferedImageOp[])new BufferedImageOp[0]) : Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.BALANCED, (int)maxWidth, (int)maxHeight, (BufferedImageOp[])new BufferedImageOp[0]);
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        JPEGImageWriteParam iwp = (JPEGImageWriteParam)writer.getDefaultWriteParam();
        int quality = 85;
        quality = Math.max(0, Math.min(quality, 100));
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality((float)quality / 100.0f);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.setOutput(ImageIO.createImageOutputStream(out));
        IIOImage iioImage = new IIOImage(thumbImage, null, null);
        writer.write(null, iioImage, iwp);
        writer.dispose();
        ByteArrayInputStream bis = new ByteArrayInputStream(out.toByteArray());
        return bis;
    }
}

