/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.jodconverter.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class JodConverterServiceImpl
implements JodConverterService,
Startable {
    private OfficeManager officeManager;
    private OfficeDocumentConverter documentConverter;
    private static final Log LOG = ExoLogger.getLogger((String)JodConverterServiceImpl.class.getName());

    public JodConverterServiceImpl(InitParams initParams) throws Exception {
        block27: {
            DefaultOfficeManagerConfiguration configuration;
            block26: {
                String maxTasksPerProcess;
                block25: {
                    String retryTimeout;
                    block24: {
                        String taskExecutionTimeout;
                        block23: {
                            String taskQueueTimeout;
                            block22: {
                                String officeHomeParam;
                                block21: {
                                    this.officeManager = null;
                                    this.documentConverter = null;
                                    officeHomeParam = initParams.getValueParam("officeHome").getValue();
                                    String portNumbers = initParams.getValueParam("port").getValue();
                                    taskQueueTimeout = initParams.getValueParam("taskQueueTimeout").getValue();
                                    taskExecutionTimeout = initParams.getValueParam("taskExecutionTimeout").getValue();
                                    maxTasksPerProcess = initParams.getValueParam("maxTasksPerProcess").getValue();
                                    retryTimeout = initParams.getValueParam("retryTimeout").getValue();
                                    configuration = new DefaultOfficeManagerConfiguration();
                                    if (portNumbers != null) {
                                        try {
                                            String[] portsList = portNumbers.split(",");
                                            int[] ports = new int[portsList.length];
                                            for (int i = 0; i < portsList.length; ++i) {
                                                ports[i] = Integer.parseInt(portsList[i].trim());
                                            }
                                            configuration.setPortNumbers(ports);
                                        }
                                        catch (NumberFormatException nfe) {
                                            if (!LOG.isWarnEnabled()) break block21;
                                            LOG.warn((Object)"Wrong configuration ==> Use default portNumbers value of DefaultOfficeManagerConfiguration");
                                        }
                                    }
                                }
                                if (officeHomeParam != null && officeHomeParam.trim().length() != 0) {
                                    try {
                                        configuration.setOfficeHome(officeHomeParam);
                                    }
                                    catch (IllegalArgumentException iae) {
                                        if (!LOG.isWarnEnabled()) break block22;
                                        LOG.warn((Object)"Wrong configuration ==> Use default officeHome value of DefaultOfficeManagerConfiguration");
                                    }
                                }
                            }
                            if (taskQueueTimeout != null) {
                                try {
                                    configuration.setTaskQueueTimeout(Long.parseLong(taskQueueTimeout));
                                }
                                catch (NumberFormatException nfe) {
                                    if (!LOG.isWarnEnabled()) break block23;
                                    LOG.warn((Object)"Wrong configuration ==> Use default taskQueueTimeout value of DefaultOfficeManagerConfiguration");
                                }
                            }
                        }
                        if (taskExecutionTimeout != null) {
                            try {
                                configuration.setTaskExecutionTimeout(Long.parseLong(taskExecutionTimeout));
                            }
                            catch (NumberFormatException nfe) {
                                if (!LOG.isWarnEnabled()) break block24;
                                LOG.warn((Object)"Wrong configuration ==> Use default taskExecutionTimeout value of DefaultOfficeManagerConfiguration");
                            }
                        }
                    }
                    if (retryTimeout != null) {
                        try {
                            configuration.setRetryTimeout(Long.parseLong(retryTimeout));
                        }
                        catch (NumberFormatException nfe) {
                            if (!LOG.isWarnEnabled()) break block25;
                            LOG.warn((Object)"Wrong configuration ==> Use default retryTimeout value of DefaultOfficeManagerConfiguration");
                        }
                    }
                }
                if (maxTasksPerProcess != null) {
                    try {
                        configuration.setMaxTasksPerProcess(Integer.parseInt(maxTasksPerProcess));
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOG.isWarnEnabled()) break block26;
                        LOG.warn((Object)"Wrong configuration ==> Use default maxTasksPerProcess value of DefaultOfficeManagerConfiguration");
                    }
                }
            }
            try {
                this.officeManager = configuration.buildOfficeManager();
                this.documentConverter = new OfficeDocumentConverter(this.officeManager);
            }
            catch (IllegalStateException ise) {
                if (!LOG.isErrorEnabled()) break block27;
                LOG.equals(ise.getMessage());
            }
        }
    }

    public void start() {
        block3: {
            try {
                if (this.officeManager != null) {
                    this.officeManager.start();
                }
            }
            catch (OfficeException oe) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Exception when start Office Service");
            }
        }
    }

    public void stop() {
        block3: {
            try {
                if (this.officeManager != null) {
                    this.officeManager.stop();
                }
            }
            catch (OfficeException oe) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Exception when stop Office Service");
            }
        }
    }

    public boolean convert(File input, File output, String outputFormat) throws OfficeException {
        if (this.officeManager != null && this.officeManager.isRunning()) {
            if (this.documentConverter != null) {
                this.documentConverter.convert(input, output, this.documentConverter.getFormatRegistry().getFormatByExtension(outputFormat));
                return true;
            }
            return false;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"this OfficeManager is currently stopped!");
        }
        return false;
    }

    public void convert(InputStream input, String formatInput, OutputStream out, String formatOutput) throws ConnectException {
        throw new UnsupportedOperationException("This method is not supported by JODConverter 3.0 anymore!");
    }
}

