/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.migration;

import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class MigrationUtil {
    static String OLD_TEMPLATE_PORLET_NAME = "Content List Viewer";
    static String NEW_TEMPLATE_PORTLET_NAME = "content-list-viewer";
    private static final Log LOG = ExoLogger.getLogger((String)MigrationUtil.class.getName());

    public static String checkAndUpdateViewerTemplate(String strTemplatePath) {
        block14: {
            if (strTemplatePath.contains(OLD_TEMPLATE_PORLET_NAME)) {
                SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
                RepositoryService repoService = WCMCoreUtils.getService(RepositoryService.class);
                try {
                    Session session = sessionProvider.getSession("dms-system", repoService.getCurrentRepository());
                    Node root = session.getRootNode();
                    String templateName = strTemplatePath.substring(strTemplatePath.lastIndexOf("/") + 1);
                    if (root.hasNode("exo:ecm/views/templates/content-list-viewer/list/" + templateName)) {
                        strTemplatePath = "/exo:ecm/views/templates/content-list-viewer/list/" + templateName;
                    } else if (root.hasNode("exo:ecm/views/templates/content-list-viewer/navigation/" + templateName)) {
                        strTemplatePath = "/exo:ecm/views/templates/content-list-viewer/navigation/" + templateName;
                    } else if (root.hasNode("exo:ecm/views/templates/content-list-viewer/paginators/" + templateName)) {
                        strTemplatePath = "/exo:ecm/views/templates/content-list-viewer/paginators/" + templateName;
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Cannot locate in new location : " + strTemplatePath));
                    }
                }
                catch (LoginException le) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)le.getMessage());
                    }
                }
                catch (NoSuchWorkspaceException nswe) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)nswe.getMessage());
                    }
                }
                catch (RepositoryException re) {
                    if (!LOG.isWarnEnabled()) break block14;
                    LOG.warn((Object)re.getMessage());
                }
            }
        }
        return strTemplatePath;
    }
}

