/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.io.IOException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;

public class IndexCleanHelper {
    public void removeWorkspaceIndex(WorkspaceEntry wsConfig, boolean isSystem) throws RepositoryConfigurationException, IOException {
        File systemIndexDir;
        String indexDirName = wsConfig.getQueryHandler().getParameterValue("index-dir");
        File indexDir = new File(indexDirName);
        if (PrivilegedFileHelper.exists(indexDir)) {
            this.removeFolder(indexDir);
        }
        if (isSystem && PrivilegedFileHelper.exists(systemIndexDir = new File(indexDirName + "_" + "system"))) {
            this.removeFolder(systemIndexDir);
        }
    }

    private void removeFolder(File dir) throws IOException {
        if (PrivilegedFileHelper.isDirectory(dir)) {
            for (File subFile : PrivilegedFileHelper.listFiles(dir)) {
                this.removeFolder(subFile);
            }
            if (!PrivilegedFileHelper.delete(dir)) {
                throw new IOException("Index folder was not deleted : " + PrivilegedFileHelper.getCanonicalPath(dir));
            }
        } else if (!PrivilegedFileHelper.delete(dir)) {
            throw new IOException("Index file was not deleted : " + PrivilegedFileHelper.getCanonicalPath(dir));
        }
    }
}

