/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagPermissionInputSet;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagPermissionManager;
import org.exoplatform.ecm.webui.selector.UIAnyPermission;
import org.exoplatform.ecm.webui.selector.UIGroupMemberSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectMemberActionListener.class})})
public class UITagPermissionForm
extends UIForm
implements UISelectable {
    public static final String PERMISSION = "permission";
    public static final String POPUP_SELECT = "SelectUserOrGroup";
    private static final Log LOG = ExoLogger.getLogger((String)UITagPermissionForm.class.getName());

    public UITagPermissionForm() throws Exception {
        this.addChild((UIComponent)new UITagPermissionInputSet(PERMISSION));
        this.setActions(new String[]{"Save"});
    }

    public void doSelect(String selectField, Object value) {
        block2: {
            try {
                this.getUIStringInput(selectField).setValue((Object)value.toString());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectMemberActionListener
    extends EventListener<UITagPermissionForm> {
        public void execute(Event<UITagPermissionForm> event) throws Exception {
            UITagPermissionForm uiForm = (UITagPermissionForm)((Object)event.getSource());
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)uiForm.createUIComponent(UIGroupMemberSelector.class, null, null);
            uiGroupMemberSelector.setSourceComponent((UIComponent)uiForm, new String[]{"userOrGroup"});
            uiGroupMemberSelector.setShowAnyPermission(false);
            uiGroupMemberSelector.removeChild(UIAnyPermission.class);
            ((UITagPermissionManager)uiForm.getAncestorOfType(UITagPermissionManager.class)).initPopupPermission((UIComponent)uiGroupMemberSelector);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UITagPermissionForm> {
        public void execute(Event<UITagPermissionForm> event) throws Exception {
            UITagPermissionForm uiForm = (UITagPermissionForm)((Object)event.getSource());
            UITagPermissionManager uiParent = (UITagPermissionManager)uiForm.getParent();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String userOrGroup = (String)((UITagPermissionInputSet)uiForm.getChild(UITagPermissionInputSet.class)).getUIStringInput("userOrGroup").getValue();
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            if (Utils.isNameEmpty((String)userOrGroup)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.userOrGroup-required", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                return;
            }
            if (newFolksonomyService.getTagPermissionList().contains(userOrGroup)) {
                uiApp.addMessage(new ApplicationMessage("UITagPermissionForm.msg.userOrGroup-alreadyExists", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                return;
            }
            newFolksonomyService.addTagPermission(userOrGroup);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
            ((UIFormStringInput)((UITagPermissionInputSet)uiForm.getChild(UITagPermissionInputSet.class)).getChild(UIFormStringInput.class)).setValue((Object)"");
        }
    }
}

