/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.action;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanAddNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotSymlinkFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.ecm.webui.component.explorer.symlink.UISymLinkManager;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={AddSymLinkActionListener.class})})
public class AddSymLinkActionComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new CanAddNodeFilter(), new IsNotLockedFilter(), new IsCheckedOutFilter(), new IsNotSymlinkFilter(), new IsNotTrashHomeNodeFilter(), new IsNotInTrashFilter(), new IsNotEditingDocumentFilter()});
    private static final Log LOG = ExoLogger.getLogger((String)AddSymLinkActionComponent.class.getName());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddSymLinkActionListener
    extends UIActionBarActionListener<AddSymLinkActionComponent> {
        public void processEvent(Event<AddSymLinkActionComponent> event) throws Exception {
            block19: {
                UIJCRExplorer uiExplorer = (UIJCRExplorer)((AddSymLinkActionComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
                UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
                String srcPath = event.getRequestContext().getRequestParameter("objectId");
                Node currentNode = uiExplorer.getCurrentNode();
                UIApplication uiApp = (UIApplication)((AddSymLinkActionComponent)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                LinkManager linkManager = (LinkManager)uiWorkingArea.getApplicationComponent(LinkManager.class);
                try {
                    if (srcPath != null && srcPath.indexOf(";") > -1) {
                        String[] nodePaths = srcPath.split(";");
                        for (int i = 0; i < nodePaths.length; ++i) {
                            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePaths[i]);
                            String wsName = null;
                            if (!matcher.find()) {
                                throw new IllegalArgumentException("The ObjectId is invalid '" + nodePaths[i] + "'");
                            }
                            wsName = matcher.group(1);
                            nodePaths[i] = matcher.group(2);
                            Session userSession = uiExplorer.getSessionByWorkspace(wsName);
                            Node selectedNode = uiExplorer.getNodeByPath(nodePaths[i], userSession, false);
                            nodePaths[i] = selectedNode.getPath();
                            if (linkManager.isLink((Item)selectedNode)) {
                                Object[] args = new Object[]{selectedNode.getPath()};
                                uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.selected-is-link", args, 1));
                                continue;
                            }
                            try {
                                String symLinkName = selectedNode.getName().indexOf(".lnk") > -1 ? selectedNode.getName() : selectedNode.getName() + ".lnk";
                                linkManager.createLink(currentNode, "exo:symlink", selectedNode, symLinkName);
                                continue;
                            }
                            catch (Exception e) {
                                Object[] arg = new Object[]{Text.unescapeIllegalJcrChars((String)selectedNode.getPath()), Text.unescapeIllegalJcrChars((String)currentNode.getPath())};
                                uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.create-link-problem", arg, 1));
                                return;
                            }
                        }
                        uiExplorer.updateAjax(event);
                        break block19;
                    }
                    if (srcPath != null) {
                        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
                        String wsName = null;
                        if (!matcher.find()) {
                            throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
                        }
                        wsName = matcher.group(1);
                        srcPath = matcher.group(2);
                        Session userSession = uiExplorer.getSessionByWorkspace(wsName);
                        Node selectedNode = uiExplorer.getNodeByPath(srcPath, userSession, false);
                        srcPath = selectedNode.getPath();
                        userSession = selectedNode.getSession();
                        if (linkManager.isLink((Item)selectedNode)) {
                            Object[] args = new Object[]{selectedNode.getPath()};
                            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.selected-is-link", args, 1));
                            return;
                        }
                        String symLinkName = selectedNode.getName().indexOf(".lnk") > -1 ? selectedNode.getName() : selectedNode.getName() + ".lnk";
                        try {
                            linkManager.createLink(currentNode, "exo:symlink", selectedNode, symLinkName);
                        }
                        catch (Exception e) {
                            Object[] arg = new Object[]{Text.unescapeIllegalJcrChars((String)selectedNode.getPath()), Text.unescapeIllegalJcrChars((String)currentNode.getPath())};
                            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.create-link-problem", arg, 1));
                            return;
                        }
                        uiExplorer.updateAjax(event);
                        break block19;
                    }
                    UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                    UISymLinkManager uiSymLinkManager = (UISymLinkManager)((AddSymLinkActionComponent)((Object)event.getSource())).createUIComponent(UISymLinkManager.class, null, null);
                    uiSymLinkManager.useWorkspaceSelector();
                    UIPopupContainer2.activate((UIComponent)uiSymLinkManager, 600, 190);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
                }
                catch (AccessControlException ace) {
                    uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.repository-exception", null, 1));
                    return;
                }
                catch (AccessDeniedException ade) {
                    uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.repository-exception", null, 1));
                    return;
                }
                catch (NumberFormatException nume) {
                    uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.numberformat-exception", null, 1));
                    return;
                }
                catch (ConstraintViolationException cve) {
                    uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.cannot-save", null, 1));
                    return;
                }
                catch (ItemExistsException iee) {
                    uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.item-exists-exception", null, 1));
                    return;
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"an unexpected error occurs while adding a symlink to the node", (Throwable)e);
                    }
                    uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.cannot-save", null, 1));
                    return;
                }
            }
        }
    }
}

