/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.permission.info;

import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl")
public class UIPermissionInputSet
extends UIFormInputSetWithAction {
    public static final String FIELD_USERORGROUP = "userOrGroup";

    public UIPermissionInputSet(String name) throws Exception {
        super(name);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        UIFormStringInput userGroup = new UIFormStringInput(FIELD_USERORGROUP, FIELD_USERORGROUP, null);
        userGroup.addValidator(MandatoryValidator.class, new Object[0]);
        userGroup.setReadOnly(true);
        this.addUIFormInput((UIFormInput)userGroup);
        for (String perm : PermissionType.ALL) {
            UICheckBoxInput checkBoxInput = new UICheckBoxInput(perm, perm, Boolean.valueOf(false));
            this.addUIFormInput((UIFormInput)checkBoxInput);
            checkBoxInput.setOnChange("OnChange");
        }
        this.setActionInfo(FIELD_USERORGROUP, new String[]{"SelectUser", "SelectMember", "AddAny"});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OnChangeActionListener
    extends EventListener<UIForm> {
        public void execute(Event<UIForm> event) throws Exception {
            UIForm permissionForm = (UIForm)event.getSource();
            UICheckBoxInput readCheckBox = permissionForm.getUICheckBoxInput("read");
            boolean isAddNodeCheckBoxChecked = permissionForm.getUICheckBoxInput("add_node").isChecked();
            boolean isSetPropertyCheckBoxChecked = permissionForm.getUICheckBoxInput("set_property").isChecked();
            boolean isRemoveCheckBoxChecked = permissionForm.getUICheckBoxInput("remove").isChecked();
            if (isAddNodeCheckBoxChecked || isSetPropertyCheckBoxChecked || isRemoveCheckBoxChecked) {
                readCheckBox.setChecked(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)permissionForm);
        }
    }
}

